/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.player;

import cn.nukkit.Player;
import cn.nukkit.event.Cancellable;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.player.PlayerEvent;
import cn.nukkit.level.Level;
import cn.nukkit.level.Location;
import cn.nukkit.level.Position;
import cn.nukkit.math.Vector3;

public class PlayerTeleportEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private TeleportCause cause;
    private Location from;
    private Location to;

    public static HandlerList getHandlers() {
        return handlers;
    }

    private PlayerTeleportEvent(Player player) {
        this.player = player;
    }

    public PlayerTeleportEvent(Player player, Location from, Location to, TeleportCause cause) {
        this(player);
        this.from = from;
        this.to = to;
        this.cause = cause;
    }

    public PlayerTeleportEvent(Player player, Vector3 from, Vector3 to, TeleportCause cause) {
        this(player);
        this.from = PlayerTeleportEvent.vectorToLocation(player.getLevel(), from);
        this.from = PlayerTeleportEvent.vectorToLocation(player.getLevel(), to);
        this.cause = cause;
    }

    public Location getFrom() {
        return this.from;
    }

    public Location getTo() {
        return this.to;
    }

    public TeleportCause getCause() {
        return this.cause;
    }

    private static Location vectorToLocation(Level baseLevel, Vector3 vector) {
        if (vector instanceof Location) {
            return (Location)vector;
        }
        if (vector instanceof Position) {
            return ((Position)vector).getLocation();
        }
        return new Location(vector.getX(), vector.getY(), vector.getZ(), 0.0, 0.0, baseLevel);
    }

    public static enum TeleportCause {
        COMMAND,
        PLUGIN,
        NETHER_PORTAL,
        END_PORTAL,
        ENDER_PEARL,
        CHORUS_FRUIT,
        UNKNOWN;

    }
}

