/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.entity;

import cn.nukkit.entity.Entity;
import cn.nukkit.event.Cancellable;
import cn.nukkit.event.HandlerList;
import cn.nukkit.event.entity.EntityEvent;
import cn.nukkit.item.Item;
import cn.nukkit.utils.EventException;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import lombok.Generated;

public class EntityDamageEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private int attackCooldown = 10;
    private final DamageCause cause;
    private final Map<DamageModifier, Float> modifiers;
    private final Map<DamageModifier, Float> originals;
    private Item weapon;

    public static HandlerList getHandlers() {
        return handlers;
    }

    public EntityDamageEvent(Entity entity, DamageCause cause, float damage) {
        this(entity, cause, new DamageModifierFloatEnumMap(damage));
    }

    public EntityDamageEvent(Entity entity, DamageCause cause, Map<DamageModifier, Float> modifiers) {
        this.entity = entity;
        this.cause = cause;
        this.modifiers = new EnumMap<DamageModifier, Float>(modifiers);
        this.originals = ImmutableMap.copyOf(this.modifiers);
        if (!this.modifiers.containsKey((Object)DamageModifier.BASE)) {
            throw new EventException("BASE Damage modifier missing");
        }
        if (entity.hasEffect(11)) {
            this.setDamage((float)(-((double)this.getDamage(DamageModifier.BASE) * 0.2 * (double)(entity.getEffect(11).getAmplifier() + 1))), DamageModifier.RESISTANCE);
        }
    }

    public DamageCause getCause() {
        return this.cause;
    }

    public float getOriginalDamage() {
        return this.getOriginalDamage(DamageModifier.BASE);
    }

    public float getOriginalDamage(DamageModifier type) {
        if (this.originals.containsKey((Object)type)) {
            return this.originals.get((Object)type).floatValue();
        }
        return 0.0f;
    }

    public float getDamage() {
        return this.getDamage(DamageModifier.BASE);
    }

    public float getDamage(DamageModifier type) {
        if (this.modifiers.containsKey((Object)type)) {
            return this.modifiers.get((Object)type).floatValue();
        }
        return 0.0f;
    }

    public void setDamage(float damage) {
        this.setDamage(damage, DamageModifier.BASE);
    }

    public void setDamage(float damage, DamageModifier type) {
        this.modifiers.put(type, Float.valueOf(damage));
    }

    public boolean isApplicable(DamageModifier type) {
        return this.modifiers.containsKey((Object)type);
    }

    public float getFinalDamage() {
        float damage = 0.0f;
        for (Float d : this.modifiers.values()) {
            if (d == null) continue;
            damage += d.floatValue();
        }
        return Math.max(damage, 0.0f);
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    public boolean canBeReducedByArmor() {
        switch (this.cause) {
            case FIRE_TICK: 
            case SUFFOCATION: 
            case DROWNING: 
            case HUNGER: 
            case FALL: 
            case VOID: 
            case MAGIC: 
            case SUICIDE: {
                return false;
            }
        }
        return true;
    }

    @Generated
    public Item getWeapon() {
        return this.weapon;
    }

    @Generated
    public void setWeapon(Item weapon) {
        this.weapon = weapon;
    }

    private static class DamageModifierFloatEnumMap
    extends EnumMap<DamageModifier, Float> {
        public DamageModifierFloatEnumMap(float damage) {
            super(DamageModifier.class);
            this.put(DamageModifier.BASE, Float.valueOf(damage));
        }
    }

    public static enum DamageCause {
        CONTACT,
        ENTITY_ATTACK,
        PROJECTILE,
        SUFFOCATION,
        FALL,
        FIRE,
        FIRE_TICK,
        LAVA,
        MAGMA,
        DROWNING,
        BLOCK_EXPLOSION,
        ENTITY_EXPLOSION,
        VOID,
        SUICIDE,
        MAGIC,
        CUSTOM,
        LIGHTNING,
        HUNGER,
        THORNS;

    }

    public static enum DamageModifier {
        BASE,
        ARMOR,
        STRENGTH,
        WEAKNESS,
        RESISTANCE,
        ABSORPTION,
        ARMOR_ENCHANTMENTS,
        CRITICAL;

    }
}

