/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event.entity;

import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.enchantment.Enchantment;
import java.util.Map;

public class EntityDamageByEntityEvent
extends EntityDamageEvent {
    private final Entity damager;
    private float knockBack;
    private Enchantment[] enchantments;

    public EntityDamageByEntityEvent(Entity damager, Entity entity, EntityDamageEvent.DamageCause cause, float damage) {
        this(damager, entity, cause, damage, 0.3f);
    }

    public EntityDamageByEntityEvent(Entity damager, Entity entity, EntityDamageEvent.DamageCause cause, Map<EntityDamageEvent.DamageModifier, Float> modifiers) {
        this(damager, entity, cause, modifiers, 0.3f);
    }

    public EntityDamageByEntityEvent(Entity damager, Entity entity, EntityDamageEvent.DamageCause cause, float damage, float knockBack) {
        super(entity, cause, damage);
        this.damager = damager;
        this.knockBack = knockBack;
        this.addAttackerModifiers(damager);
    }

    public EntityDamageByEntityEvent(Entity damager, Entity entity, EntityDamageEvent.DamageCause cause, Map<EntityDamageEvent.DamageModifier, Float> modifiers, float knockBack) {
        this(damager, entity, cause, modifiers, knockBack, new Enchantment[0]);
    }

    public EntityDamageByEntityEvent(Entity damager, Entity entity, EntityDamageEvent.DamageCause cause, Map<EntityDamageEvent.DamageModifier, Float> modifiers, float knockBack, Enchantment[] enchantments) {
        super(entity, cause, modifiers);
        this.damager = damager;
        this.knockBack = knockBack;
        this.enchantments = enchantments;
        this.addAttackerModifiers(damager);
    }

    protected void addAttackerModifiers(Entity damager) {
        if (damager.hasEffect(5)) {
            this.setDamage((float)((double)this.getDamage(EntityDamageEvent.DamageModifier.BASE) * 0.3 * (double)(damager.getEffect(5).getAmplifier() + 1)), EntityDamageEvent.DamageModifier.STRENGTH);
        }
        if (damager.hasEffect(18)) {
            this.setDamage(-((float)((double)this.getDamage(EntityDamageEvent.DamageModifier.BASE) * 0.2 * (double)(damager.getEffect(18).getAmplifier() + 1))), EntityDamageEvent.DamageModifier.WEAKNESS);
        }
    }

    public Entity getDamager() {
        return this.damager;
    }

    public float getKnockBack() {
        return this.knockBack;
    }

    public void setKnockBack(float knockBack) {
        this.knockBack = knockBack;
    }

    public Enchantment[] getWeaponEnchantments() {
        return this.enchantments;
    }
}

