/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.event;

import cn.nukkit.event.Event;
import cn.nukkit.event.EventPriority;
import cn.nukkit.event.Listener;
import cn.nukkit.plugin.Plugin;
import cn.nukkit.plugin.RegisteredListener;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class HandlerList {
    private volatile RegisteredListener[] handlers = null;
    private final EnumMap<EventPriority, List<RegisteredListener>> handlerslots = new EnumMap(EventPriority.class);
    private static final List<HandlerList> allLists = new ObjectArrayList<HandlerList>();
    private static final Map<Class<?>, HandlerList> eventHandlerLists = new Object2ObjectOpenHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bakeAll() {
        List<HandlerList> list = allLists;
        synchronized (list) {
            for (HandlerList h2 : allLists) {
                h2.bake();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAll() {
        List<HandlerList> list = allLists;
        synchronized (list) {
            Iterator<HandlerList> iterator = allLists.iterator();
            while (iterator.hasNext()) {
                HandlerList h2;
                HandlerList handlerList = h2 = iterator.next();
                synchronized (handlerList) {
                    for (List<RegisteredListener> list2 : h2.handlerslots.values()) {
                        list2.clear();
                    }
                    h2.handlers = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAll(Plugin plugin) {
        List<HandlerList> list = allLists;
        synchronized (list) {
            for (HandlerList h2 : allLists) {
                h2.unregister(plugin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterAll(Listener listener) {
        List<HandlerList> list = allLists;
        synchronized (list) {
            for (HandlerList h2 : allLists) {
                h2.unregister(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HandlerList() {
        for (EventPriority o : EventPriority.values()) {
            this.handlerslots.put(o, new ObjectArrayList());
        }
        List<HandlerList> list = allLists;
        synchronized (list) {
            allLists.add(this);
        }
    }

    public synchronized void register(RegisteredListener listener) {
        if (this.handlerslots.get((Object)listener.getPriority()).contains(listener)) {
            throw new IllegalStateException("This listener is already registered to priority " + listener.getPriority().toString());
        }
        this.handlers = null;
        this.handlerslots.get((Object)listener.getPriority()).add(listener);
    }

    public void registerAll(Collection<RegisteredListener> listeners) {
        for (RegisteredListener listener : listeners) {
            this.register(listener);
        }
    }

    public synchronized void unregister(RegisteredListener listener) {
        if (this.handlerslots.get((Object)listener.getPriority()).remove(listener)) {
            this.handlers = null;
        }
    }

    public synchronized void unregister(Plugin plugin) {
        boolean changed = false;
        for (List<RegisteredListener> list : this.handlerslots.values()) {
            ListIterator<RegisteredListener> i = list.listIterator();
            while (i.hasNext()) {
                if (!i.next().getPlugin().equals(plugin)) continue;
                i.remove();
                changed = true;
            }
        }
        if (changed) {
            this.handlers = null;
        }
    }

    public synchronized void unregister(Listener listener) {
        boolean changed = false;
        for (List<RegisteredListener> list : this.handlerslots.values()) {
            ListIterator<RegisteredListener> i = list.listIterator();
            while (i.hasNext()) {
                if (!i.next().getListener().equals(listener)) continue;
                i.remove();
                changed = true;
            }
        }
        if (changed) {
            this.handlers = null;
        }
    }

    public synchronized void bake() {
        if (this.handlers != null) {
            return;
        }
        ObjectArrayList entries = new ObjectArrayList();
        for (Map.Entry<EventPriority, List<RegisteredListener>> entry : this.handlerslots.entrySet()) {
            entries.addAll(entry.getValue());
        }
        this.handlers = entries.toArray(new RegisteredListener[0]);
    }

    public RegisteredListener[] getRegisteredListeners() {
        RegisteredListener[] handlers;
        while (true) {
            handlers = this.handlers;
            if (this.handlers != null) break;
            this.bake();
        }
        return handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<RegisteredListener> getRegisteredListeners(Plugin plugin) {
        ArrayList<RegisteredListener> listeners = new ArrayList<RegisteredListener>();
        List<HandlerList> list = allLists;
        synchronized (list) {
            Iterator<HandlerList> iterator = allLists.iterator();
            while (iterator.hasNext()) {
                HandlerList h2;
                HandlerList handlerList = h2 = iterator.next();
                synchronized (handlerList) {
                    for (List<RegisteredListener> list2 : h2.handlerslots.values()) {
                        for (RegisteredListener listener : list2) {
                            if (!listener.getPlugin().equals(plugin)) continue;
                            listeners.add(listener);
                        }
                    }
                }
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<HandlerList> getHandlerLists() {
        List<HandlerList> list = allLists;
        synchronized (list) {
            return new ArrayList<HandlerList>(allLists);
        }
    }

    public static HandlerList getCachedHandlerList(Class<? extends Event> clazz) {
        return eventHandlerLists.get(clazz);
    }

    public static void putCachedHandlerList(Class<? extends Event> clazz, HandlerList handlerList) {
        eventHandlerLists.put(clazz, handlerList);
    }
}

