/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.weather;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockFire;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.weather.EntityLightningStrike;
import cn.nukkit.event.block.BlockIgniteEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.Utils;

public class EntityLightning
extends Entity
implements EntityLightningStrike {
    public static final int NETWORK_ID = 93;
    protected boolean isEffect = true;
    public int state;
    public int liveTime;

    @Override
    public int getNetworkId() {
        return 93;
    }

    public EntityLightning(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initEntity() {
        Block block;
        super.initEntity();
        this.state = 2;
        this.liveTime = Utils.random.nextInt(3) + 1;
        if (this.isEffect && this.level.gameRules.getBoolean(GameRule.DO_FIRE_TICK) && this.server.getDifficulty() >= 2 && ((block = this.level.getBlock(this.chunk, this.getFloorX(), this.getFloorY(), this.getFloorZ(), true)).getId() == 0 || block.getId() == 31)) {
            BlockFire fire = (BlockFire)Block.get(51);
            fire.x = block.x;
            fire.y = block.y;
            fire.z = block.z;
            fire.level = this.level;
            if (fire.isBlockTopFacingSurfaceSolid(fire.down()) || fire.canNeighborBurn()) {
                BlockIgniteEvent e = new BlockIgniteEvent(block, null, this, BlockIgniteEvent.BlockIgniteCause.LIGHTNING);
                this.getServer().getPluginManager().callEvent(e);
                if (!e.isCancelled()) {
                    this.level.setBlock(fire, fire, true);
                    this.level.scheduleUpdate(fire, fire.tickRate() + Utils.random.nextInt(10));
                }
            }
        }
    }

    @Override
    public boolean isEffect() {
        return this.isEffect;
    }

    @Override
    public void setEffect(boolean e) {
        this.isEffect = e;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        source.setDamage(0.0f);
        return super.attack(source);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        this.lastUpdate = currentTick;
        this.entityBaseTick(tickDiff);
        if (this.state == 2) {
            this.level.addLevelSoundEvent(this, 47, -1, 93);
            this.level.addLevelSoundEvent(this, 48, -1, 93);
        }
        --this.state;
        if (this.state < 0) {
            if (this.liveTime == 0) {
                this.close();
                return false;
            }
            if (this.state < -Utils.random.nextInt(10)) {
                Block block;
                --this.liveTime;
                this.state = 1;
                if (this.isEffect && this.level.gameRules.getBoolean(GameRule.DO_FIRE_TICK) && ((block = this.level.getBlock(this.chunk, this.getFloorX(), this.getFloorY(), this.getFloorZ(), true)).getId() == 0 || block.getId() == 31)) {
                    BlockIgniteEvent e = new BlockIgniteEvent(block, null, this, BlockIgniteEvent.BlockIgniteCause.LIGHTNING);
                    this.getServer().getPluginManager().callEvent(e);
                    if (!e.isCancelled()) {
                        Block fire = Block.get(51);
                        this.level.setBlock(block, fire);
                        this.getLevel().scheduleUpdate(fire, fire.tickRate());
                    }
                }
            }
        }
        if (this.state >= 0 && this.isEffect) {
            AxisAlignedBB bb = this.getBoundingBox().grow(3.0, 3.0, 3.0);
            bb.setMaxX(bb.getMaxX() + 6.0);
            for (Entity entity : this.level.getCollidingEntities(bb, this)) {
                entity.onStruckByLightning(this);
            }
        }
        return true;
    }

    @Override
    public boolean canSaveToStorage() {
        return false;
    }
}

