/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.projectile;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.data.LongEntityData;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.entity.weather.EntityLightning;
import cn.nukkit.event.entity.EntityDamageByChildEntityEvent;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.ProjectileHitEvent;
import cn.nukkit.event.weather.LightningStrikeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.MovingObjectPosition;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockVector3;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.nbt.tag.ListTag;

public class EntityThrownTrident
extends EntityProjectile {
    public static final int NETWORK_ID = 73;
    protected Item trident;
    protected int pickupMode;
    private Vector3 collisionPos;
    private BlockVector3 stuckToBlockPos;
    private int favoredSlot;
    private boolean player;
    private int loyaltyLevel;
    private boolean hasChanneling;
    private boolean didHit;
    private int impalingLevel;
    private static final Vector3 defaultCollisionPos = new Vector3(0.0, 0.0, 0.0);
    private static final BlockVector3 defaultStuckToBlockPos = new BlockVector3(0, 0, 0);

    @Override
    public int getNetworkId() {
        return 73;
    }

    @Override
    public float getWidth() {
        return 0.25f;
    }

    @Override
    public float getLength() {
        return 0.25f;
    }

    @Override
    public float getHeight() {
        return 0.35f;
    }

    @Override
    public float getGravity() {
        return 0.04f;
    }

    @Override
    public float getDrag() {
        return 0.01f;
    }

    public EntityThrownTrident(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntityThrownTrident(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        super(chunk, nbt, shootingEntity);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        int n = this.pickupMode = this.namedTag.contains("pickup") ? this.namedTag.getByte("pickup") : 1;
        if (this.namedTag.contains("Trident")) {
            this.trident = NBTIO.getItemHelper(this.namedTag.getCompound("Trident"));
            this.loyaltyLevel = this.trident.getEnchantmentLevel(31);
            this.hasChanneling = this.trident.hasEnchantment(32);
            this.impalingLevel = this.trident.getEnchantmentLevel(29);
        } else {
            this.trident = Item.get(0);
            this.loyaltyLevel = 0;
            this.hasChanneling = false;
            this.impalingLevel = 0;
        }
        if (this.namedTag.contains("CollisionPos")) {
            ListTag<DoubleTag> collisionPosList = this.namedTag.getList("CollisionPos", DoubleTag.class);
            this.collisionPos = new Vector3(collisionPosList.get((int)0).data, collisionPosList.get((int)1).data, collisionPosList.get((int)2).data);
        } else {
            this.collisionPos = defaultCollisionPos.clone();
        }
        if (this.namedTag.contains("StuckToBlockPos")) {
            ListTag<IntTag> stuckToBlockPosList = this.namedTag.getList("StuckToBlockPos", IntTag.class);
            this.stuckToBlockPos = new BlockVector3(stuckToBlockPosList.get((int)0).data, stuckToBlockPosList.get((int)1).data, stuckToBlockPosList.get((int)2).data);
        } else {
            this.stuckToBlockPos = defaultStuckToBlockPos.clone();
        }
        this.favoredSlot = this.namedTag.contains("favoredSlot") ? this.namedTag.getInt("favoredSlot") : -1;
        this.player = this.namedTag.contains("player") ? this.namedTag.getBoolean("player") : true;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.put("Trident", NBTIO.putItemHelper(this.trident));
        this.namedTag.putByte("pickup", this.pickupMode);
        this.namedTag.putList(new ListTag<DoubleTag>("CollisionPos").add(new DoubleTag("0", this.collisionPos.x)).add(new DoubleTag("1", this.collisionPos.y)).add(new DoubleTag("2", this.collisionPos.z)));
        this.namedTag.putList(new ListTag<IntTag>("StuckToBlockPos").add(new IntTag("0", this.stuckToBlockPos.x)).add(new IntTag("1", this.stuckToBlockPos.y)).add(new IntTag("2", this.stuckToBlockPos.z)));
        this.namedTag.putInt("favoredSlot", this.favoredSlot);
        this.namedTag.putBoolean("player", this.player);
    }

    public Item getItem() {
        return this.trident != null ? this.trident.clone() : Item.get(0);
    }

    public void setItem(Item item) {
        this.trident = item.clone();
        this.loyaltyLevel = this.trident.getEnchantmentLevel(31);
        this.hasChanneling = this.trident.hasEnchantment(32);
        this.impalingLevel = this.trident.getEnchantmentLevel(29);
    }

    @Override
    protected double getBaseDamage() {
        return 8.0;
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        if (this.age > 1200 && this.pickupMode < 1) {
            this.close();
            return false;
        }
        boolean hasUpdate = super.onUpdate(currentTick);
        if (this.noClip) {
            if (this.canReturnToShooter()) {
                Entity shooter = this.shootingEntity;
                Vector3 vector3 = new Vector3(shooter.x - this.x, shooter.y + (double)shooter.getEyeHeight() - this.y, shooter.z - this.z);
                this.setPosition(new Vector3(this.x, this.y + vector3.y * 0.015 * (double)this.loyaltyLevel, this.z));
                this.setMotion(this.getMotion().multiply(0.95).add(vector3.multiply((double)this.loyaltyLevel * 0.05)));
                hasUpdate = true;
            } else {
                if (!this.closed && this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
                    this.level.dropItem(this, this.trident);
                }
                this.close();
            }
        }
        return hasUpdate;
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        if (this.noClip) {
            return;
        }
        this.server.getPluginManager().callEvent(new ProjectileHitEvent(this, MovingObjectPosition.fromEntity(entity)));
        float damage = this.getResultDamage();
        if (this.impalingLevel > 0 && (entity.isInsideOfWater() || entity.getLevel().isRaining() && entity.canSeeSky())) {
            damage += 2.5f * (float)this.impalingLevel;
        }
        EntityDamageByEntityEvent ev = this.shootingEntity == null ? new EntityDamageByEntityEvent((Entity)this, entity, EntityDamageEvent.DamageCause.PROJECTILE, damage, this.knockBack) : new EntityDamageByChildEntityEvent(this.shootingEntity, (Entity)this, entity, EntityDamageEvent.DamageCause.PROJECTILE, damage, this.knockBack);
        entity.attack(ev);
        this.hadCollision = true;
        this.onHit();
        this.setCollisionPos(this);
        this.setMotion(new Vector3(this.getMotion().getX() * -0.01, this.getMotion().getY() * -0.1, this.getMotion().getZ() * -0.01));
        if (this.hasChanneling && !this.didHit) {
            this.didHit = true;
            if (this.level.isThundering() && this.canSeeSky()) {
                EntityLightning bolt = (EntityLightning)Entity.createEntity(93, this.getChunk(), EntityThrownTrident.getDefaultNBT(this), new Object[0]);
                LightningStrikeEvent strikeEvent = new LightningStrikeEvent(this.level, bolt);
                this.server.getPluginManager().callEvent(strikeEvent);
                if (!strikeEvent.isCancelled()) {
                    bolt.spawnToAll();
                    this.level.addLevelSoundEvent(this, 184);
                } else {
                    bolt.setEffect(false);
                }
            }
        }
        if (this.canReturnToShooter()) {
            this.getLevel().addLevelSoundEvent(this, 179);
            this.noClip = true;
            this.hadCollision = false;
            this.setRope(true);
        }
    }

    @Override
    public void onHit() {
        this.getLevel().addLevelSoundEvent(this, 178);
    }

    @Override
    public void onHitGround(Vector3 moveVector) {
        if (this.noClip) {
            return;
        }
        super.onHitGround(moveVector);
        this.setStuckToBlockPos(new BlockVector3(moveVector.getFloorX(), moveVector.getFloorY(), moveVector.getFloorZ()));
        if (this.canReturnToShooter()) {
            this.getLevel().addLevelSoundEvent(this, 179);
            this.noClip = true;
            this.setRope(true);
        }
    }

    public Vector3 getCollisionPos() {
        return this.collisionPos;
    }

    public void setCollisionPos(Vector3 collisionPos) {
        this.collisionPos = collisionPos;
    }

    public BlockVector3 getStuckToBlockPos() {
        return this.stuckToBlockPos;
    }

    public void setStuckToBlockPos(BlockVector3 stuckToBlockPos) {
        this.stuckToBlockPos = stuckToBlockPos;
    }

    public int getFavoredSlot() {
        return this.favoredSlot;
    }

    public void setFavoredSlot(int favoredSlot) {
        this.favoredSlot = favoredSlot;
    }

    public boolean shotByPlayer() {
        return this.player;
    }

    public void setShotByPlayer(boolean player) {
        this.player = player;
    }

    public void setRope(boolean tridentRope) {
        if (tridentRope) {
            this.setDataProperty(new LongEntityData(5, this.shootingEntity.getId()));
        } else {
            this.setDataProperty(new LongEntityData(5, -1L));
        }
        this.setDataFlag(0, 53, tridentRope);
    }

    private boolean canReturnToShooter() {
        if (this.loyaltyLevel <= 0) {
            return false;
        }
        if (this.getCollisionPos().equals(defaultCollisionPos) && this.getStuckToBlockPos().equals(defaultStuckToBlockPos)) {
            return false;
        }
        Entity shooter = this.shootingEntity;
        if (shooter != null) {
            return shooter instanceof Player && shooter.isAlive() && !shooter.isClosed() && shooter.getLevel().getId() == this.getLevel().getId() && !((Player)shooter).isSpectator();
        }
        return false;
    }

    public int getPickupMode() {
        return this.pickupMode;
    }

    public void setPickupMode(int pickupMode) {
        this.pickupMode = pickupMode;
    }
}

