/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.projectile;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.item.EntityBoat;
import cn.nukkit.entity.item.EntityEndCrystal;
import cn.nukkit.entity.item.EntityFishingHook;
import cn.nukkit.entity.item.EntityMinecartAbstract;
import cn.nukkit.entity.item.EntityPainting;
import cn.nukkit.entity.mob.EntityBlaze;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.entity.projectile.EntitySnowball;
import cn.nukkit.entity.projectile.EntityThrownTrident;
import cn.nukkit.event.entity.EntityCombustByEntityEvent;
import cn.nukkit.event.entity.EntityDamageByChildEntityEvent;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.ProjectileHitEvent;
import cn.nukkit.item.ItemArrow;
import cn.nukkit.level.MovingObjectPosition;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.concurrent.ThreadLocalRandom;

public abstract class EntityProjectile
extends Entity {
    public static final int DATA_SHOOTER_ID = 17;
    public static final int PICKUP_NONE_REMOVE = -1;
    public static final int PICKUP_NONE = 0;
    public static final int PICKUP_ANY = 1;
    public static final int PICKUP_CREATIVE = 2;
    public Entity shootingEntity;
    public float knockBack = 0.3f;
    public boolean hadCollision = false;
    public int piercing;

    protected double getDamage() {
        return this.namedTag.contains("damage") ? this.namedTag.getDouble("damage") : this.getBaseDamage();
    }

    protected double getBaseDamage() {
        return 0.0;
    }

    public EntityProjectile(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntityProjectile(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        super(chunk, nbt);
        this.shootingEntity = shootingEntity;
    }

    public int getResultDamage() {
        return NukkitMath.ceilDouble(this.getDamage());
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        return source.getCause() == EntityDamageEvent.DamageCause.VOID && super.attack(source);
    }

    public void onCollideWithEntity(Entity entity) {
        this.server.getPluginManager().callEvent(new ProjectileHitEvent(this, MovingObjectPosition.fromEntity(entity)));
        float damage = this instanceof EntitySnowball && entity instanceof EntityBlaze ? 3.0f : (float)this.getResultDamage();
        EntityDamageByEntityEvent ev = this.shootingEntity == null ? new EntityDamageByEntityEvent((Entity)this, entity, EntityDamageEvent.DamageCause.PROJECTILE, damage, this.knockBack) : new EntityDamageByChildEntityEvent(this.shootingEntity, (Entity)this, entity, EntityDamageEvent.DamageCause.PROJECTILE, damage, this.knockBack);
        if (entity.attack(ev)) {
            this.hadCollision = true;
            this.onHit();
            if (this.fireTicks > 0 && entity.isAlive()) {
                EntityCombustByEntityEvent event = new EntityCombustByEntityEvent(this, entity, 5);
                this.server.getPluginManager().callEvent(event);
                if (!event.isCancelled()) {
                    entity.setOnFire(event.getDuration());
                }
            }
            if (this instanceof EntityArrow && entity instanceof EntityLiving) {
                EntityProjectile.addEffectFromTippedArrow(entity, ItemArrow.getEffect(((EntityArrow)this).getData()), ev.getFinalDamage());
            }
        }
        this.close();
    }

    @Override
    protected void initEntity() {
        this.setMaxHealth(1);
        super.initEntity();
        this.setHealth(1.0f);
        if (this.namedTag.contains("Age")) {
            this.age = this.namedTag.getShort("Age");
        }
        if (this.namedTag.contains("knockback")) {
            this.knockBack = this.namedTag.getFloat("knockback");
        }
        this.updateRotation();
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return (entity instanceof EntityLiving || entity instanceof EntityEndCrystal || entity instanceof EntityMinecartAbstract || entity instanceof EntityBoat || entity instanceof EntityPainting) && !this.onGround && !entity.noClip && !this.noClip;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putShort("Age", this.age);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        this.lastUpdate = currentTick;
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        if (this.isAlive()) {
            MovingObjectPosition movingObjectPosition = null;
            if (!this.isCollided) {
                this.motionY = this.isInsideOfWater() ? (this.motionY -= (double)(this.getGravity() - this.getGravity() / 2.0f)) : (this.motionY -= (double)this.getGravity());
                this.motionX *= (double)(1.0f - this.getDrag());
                this.motionZ *= (double)(1.0f - this.getDrag());
            } else if (this.updateMode % 3 == 1) {
                this.updateMode = 5;
                this.blocksAround = null;
                this.collisionBlocks = null;
                if (!this.level.hasCollisionBlocks(this, this.boundingBox.grow(0.01, 0.01, 0.01))) {
                    this.motionY = -1.0E-5;
                }
            }
            Vector3 moveVector = new Vector3(this.x + this.motionX, this.y + this.motionY, this.z + this.motionZ);
            Entity[] list = this.noClip ? new Entity[]{} : this.getLevel().getCollidingEntities(this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0), this);
            double nearDistance = 2.147483647E9;
            Entity nearEntity = null;
            for (Entity entity : list) {
                double distance;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition ob;
                if (entity == this.shootingEntity && this.age < 5 || entity instanceof Player && ((Player)entity).getGamemode() == 3 || (ob = (axisalignedbb = entity.boundingBox.grow(0.3, 0.3, 0.3)).calculateIntercept(this, moveVector)) == null || !((distance = this.distanceSquared(ob.hitVector)) < nearDistance)) continue;
                nearDistance = distance;
                nearEntity = entity;
            }
            if (nearEntity != null) {
                movingObjectPosition = MovingObjectPosition.fromEntity(nearEntity);
            }
            if (movingObjectPosition != null && movingObjectPosition.entityHit != null) {
                this.onCollideWithEntity(movingObjectPosition.entityHit);
                return true;
            }
            this.move(this.motionX, this.motionY, this.motionZ);
            if (this.isCollided && !this.hadCollision) {
                if (!(this instanceof EntityFishingHook)) {
                    this.addMovement(this.x, this.y, this.z, this.lastYaw, this.lastPitch, this.lastYaw);
                }
                this.hadCollision = true;
                this.motionX = 0.0;
                this.motionY = 0.0;
                this.motionZ = 0.0;
                this.server.getPluginManager().callEvent(new ProjectileHitEvent(this, MovingObjectPosition.fromBlock(this.getFloorX(), this.getFloorY(), this.getFloorZ(), -1, this)));
                this.onHit();
                this.onHitGround(moveVector);
                if (this instanceof EntityArrow || this instanceof EntityThrownTrident) {
                    this.updateMode = 5;
                }
                return false;
            }
            if (!this.isCollided && this.hadCollision) {
                this.hadCollision = false;
            }
            if (!this.hadCollision || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5) {
                this.updateRotation();
                hasUpdate = true;
            }
            this.updateMovement();
        }
        return hasUpdate;
    }

    public void updateRotation() {
        double f = Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
        this.yaw = Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI;
        this.pitch = Math.atan2(this.motionY, f) * 180.0 / Math.PI;
    }

    public void inaccurate(float modifier) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        this.motionX += rand.nextGaussian() * (double)0.0075f * (double)modifier;
        this.motionY += rand.nextGaussian() * (double)0.0075f * (double)modifier;
        this.motionZ += rand.nextGaussian() * (double)0.0075f * (double)modifier;
    }

    protected void onHit() {
    }

    protected void onHitGround(Vector3 moveVector) {
        Block block = this.level.getBlock(this.chunk, moveVector.getFloorX(), moveVector.getFloorY(), moveVector.getFloorZ(), false);
        block.onEntityCollide(this);
    }
}

