/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.projectile;

import cn.nukkit.entity.Entity;
import cn.nukkit.entity.data.ByteEntityData;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.Utils;

public class EntityArrow
extends EntityProjectile {
    public static final int NETWORK_ID = 80;
    protected int pickupMode;
    protected boolean critical;
    private int arrowData;
    private boolean isFromCrossbow;

    @Override
    public int getNetworkId() {
        return 80;
    }

    @Override
    public float getWidth() {
        return 0.05f;
    }

    @Override
    public float getLength() {
        return 0.5f;
    }

    @Override
    public float getHeight() {
        return 0.05f;
    }

    @Override
    public float getGravity() {
        return 0.05f;
    }

    @Override
    public float getDrag() {
        return 0.01f;
    }

    public EntityArrow(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntityArrow(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        this(chunk, nbt, shootingEntity, false);
    }

    public EntityArrow(FullChunk chunk, CompoundTag nbt, Entity shootingEntity, boolean critical) {
        this(chunk, nbt, shootingEntity, critical, false);
    }

    public EntityArrow(FullChunk chunk, CompoundTag nbt, Entity shootingEntity, boolean critical, boolean isFromCrossbow) {
        super(chunk, nbt, shootingEntity);
        this.setCritical(critical);
        this.isFromCrossbow = isFromCrossbow;
    }

    public void setData(int data) {
        if (data < 0) {
            throw new IllegalArgumentException("data < 0");
        }
        this.arrowData = data;
        this.setDataProperty(new ByteEntityData(18, this.arrowData), false);
    }

    public int getData() {
        return this.arrowData;
    }

    public boolean isFromCrossbow() {
        return this.isFromCrossbow;
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.pickupMode = this.namedTag.contains("pickup") ? this.namedTag.getByte("pickup") : 1;
        int data = this.namedTag.getByte("arrowData");
        if (data != 0) {
            this.setData(data);
        }
        this.isFromCrossbow = this.namedTag.getBoolean("isFromCrossbow");
    }

    public void setCritical() {
        this.setCritical(true);
    }

    public void setCritical(boolean value) {
        if (this.critical != value) {
            this.critical = value;
            this.setDataFlag(0, 13, value);
        }
    }

    public boolean isCritical() {
        return this.critical;
    }

    @Override
    public int getResultDamage() {
        int base = NukkitMath.ceilDouble(Math.sqrt(this.motionX * this.motionX + this.motionY * this.motionY + this.motionZ * this.motionZ) * this.getDamage());
        if (this.isCritical()) {
            base += Utils.random.nextInt((base >> 1) + 2);
        }
        if (this.isFromCrossbow) {
            base += 2;
        }
        return base;
    }

    @Override
    protected double getBaseDamage() {
        return 2.0;
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        if (this.age > 1200) {
            this.close();
            return false;
        }
        if (this.fireTicks > 0 && this.level.isRaining() && this.canSeeSky()) {
            this.extinguish();
        }
        return super.onUpdate(currentTick);
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putByte("pickup", this.pickupMode);
        this.namedTag.putByte("arrowData", this.arrowData);
        this.namedTag.putBoolean("isFromCrossbow", this.isFromCrossbow);
    }

    public int getPickupMode() {
        return this.pickupMode;
    }

    public void setPickupMode(int pickupMode) {
        this.pickupMode = pickupMode;
    }

    @Override
    public void onHit() {
        this.getLevel().addLevelSoundEvent(this, 63);
    }

    @Override
    public void onHitGround(Vector3 moveVector) {
        super.onHitGround(moveVector);
        this.setCritical(false);
    }
}

