/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.passive;

import cn.nukkit.entity.passive.EntityFish;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.Utils;

public class EntityTropicalFish
extends EntityFish {
    public static final int NETWORK_ID = 111;
    private int variantA;
    private int variantB;
    private int color;

    public EntityTropicalFish(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initEntity() {
        this.setMaxHealth(3);
        super.initEntity();
        this.variantA = this.namedTag.contains("VariantA") ? this.namedTag.getInt("VariantA") : Utils.rand(0, 5);
        this.dataProperties.putInt(2, this.variantA);
        this.variantB = this.namedTag.contains("VariantB") ? this.namedTag.getInt("VariantB") : Utils.rand(0, 5);
        this.dataProperties.putInt(43, this.variantB);
        this.color = this.namedTag.contains("Color") ? this.namedTag.getInt("Color") : Utils.rand(0, 15);
        this.dataProperties.putByte(3, this.color);
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putInt("VariantA", this.variantA);
        this.namedTag.putInt("VariantB", this.variantB);
        this.namedTag.putInt("Color", this.color);
    }

    @Override
    int getBucketMeta() {
        return 4;
    }

    @Override
    public int getNetworkId() {
        return 111;
    }

    @Override
    public float getWidth() {
        return 0.5f;
    }

    @Override
    public float getHeight() {
        return 0.4f;
    }

    @Override
    public Item[] getDrops() {
        return new Item[]{Item.get(461, (Integer)0, 1), Item.get(352, (Integer)0, Utils.rand(0, 2))};
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.getNameTag() : "Tropical Fish";
    }
}

