/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.passive;

import cn.nukkit.Player;
import cn.nukkit.entity.data.ByteEntityData;
import cn.nukkit.entity.passive.EntityWalkingAnimal;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemDye;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.DyeColor;
import cn.nukkit.utils.Utils;
import java.util.ArrayList;

public class EntitySheep
extends EntityWalkingAnimal {
    public static final int NETWORK_ID = 13;
    private boolean sheared = false;
    private int color;

    public EntitySheep(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public int getNetworkId() {
        return 13;
    }

    @Override
    public float getWidth() {
        if (this.isBaby()) {
            return 0.45f;
        }
        return 0.9f;
    }

    @Override
    public float getHeight() {
        if (this.isBaby()) {
            return 0.65f;
        }
        return 1.3f;
    }

    @Override
    public void initEntity() {
        this.setMaxHealth(8);
        super.initEntity();
        if (!this.namedTag.contains("Color")) {
            this.setColor(this.randomColor());
        } else {
            this.setColor(this.namedTag.getByte("Color"));
        }
        if (!this.namedTag.contains("Sheared")) {
            this.namedTag.putBoolean("Sheared", false);
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putByte("Color", this.color);
        this.namedTag.putBoolean("Sheared", this.isSheared());
    }

    @Override
    public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        if (item.getId() == 351) {
            switch (item.getDamage()) {
                case 4: 
                case 15: {
                    return false;
                }
                case 19: {
                    this.setColor(DyeColor.WHITE.getWoolData());
                    break;
                }
                case 18: {
                    this.setColor(DyeColor.BLUE.getWoolData());
                    break;
                }
                case 17: {
                    this.setColor(DyeColor.BROWN.getWoolData());
                    break;
                }
                case 16: {
                    this.setColor(DyeColor.BLACK.getWoolData());
                    break;
                }
                default: {
                    this.setColor(((ItemDye)item).getDyeColor().getWoolData());
                }
            }
            return true;
        }
        return super.onInteract(player, item, clickedPos);
    }

    public void shear(boolean shear) {
        this.sheared = shear;
        this.setDataFlag(0, 31, shear);
        if (shear) {
            this.level.dropItem(this, Item.get(35, (Integer)this.getColor(), Utils.rand(1, 3)));
        }
    }

    @Override
    public Item[] getDrops() {
        ArrayList<Item> drops = new ArrayList<Item>();
        if (!this.isBaby()) {
            if (!this.sheared) {
                drops.add(Item.get(35, (Integer)this.getColor(), 1));
            }
            for (int i = 0; i < Utils.rand(1, 2); ++i) {
                drops.add(Item.get(this.isOnFire() ? 424 : 423, (Integer)0, 1));
            }
        }
        return drops.toArray(new Item[0]);
    }

    public void setColor(int woolColor) {
        this.color = woolColor;
        this.namedTag.putByte("Color", woolColor);
        this.setDataProperty(new ByteEntityData(3, woolColor));
    }

    public int getColor() {
        return this.color;
    }

    private int randomColor() {
        int rand = Utils.rand(1, 200);
        if (rand == 1) {
            return DyeColor.PINK.getWoolData();
        }
        if (rand < 8) {
            return DyeColor.BROWN.getWoolData();
        }
        if (rand < 18) {
            return DyeColor.GRAY.getWoolData();
        }
        if (rand < 28) {
            return DyeColor.LIGHT_GRAY.getWoolData();
        }
        if (rand < 38) {
            return DyeColor.BLACK.getWoolData();
        }
        return DyeColor.WHITE.getWoolData();
    }

    @Override
    public int getKillExperience() {
        return this.isBaby() ? 0 : Utils.rand(1, 3);
    }

    public boolean isSheared() {
        return this.sheared;
    }
}

