/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.passive;

import cn.nukkit.entity.passive.EntityJumpingAnimal;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.Utils;
import java.util.ArrayList;

public class EntityRabbit
extends EntityJumpingAnimal {
    public static final int NETWORK_ID = 18;

    public EntityRabbit(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public int getNetworkId() {
        return 18;
    }

    @Override
    public float getWidth() {
        if (this.isBaby()) {
            return 0.2f;
        }
        return 0.4f;
    }

    @Override
    public float getHeight() {
        if (this.isBaby()) {
            return 0.25f;
        }
        return 0.5f;
    }

    @Override
    public void initEntity() {
        this.setMaxHealth(3);
        super.initEntity();
    }

    @Override
    public Item[] getDrops() {
        ArrayList<Item> drops = new ArrayList<Item>();
        if (!this.isBaby()) {
            drops.add(Item.get(415, (Integer)0, Utils.rand(0, 1)));
            drops.add(Item.get(this.isOnFire() ? 412 : 411, (Integer)0, Utils.rand(0, 1)));
            for (int i = 0; i < (Utils.rand(0, 101) <= 9 ? 1 : 0); ++i) {
                drops.add(Item.get(414, (Integer)0, 1));
            }
        }
        return drops.toArray(new Item[0]);
    }

    @Override
    public int getKillExperience() {
        return this.isBaby() ? 0 : Utils.rand(1, 3);
    }
}

