/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.mob;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntitySmite;
import cn.nukkit.entity.mob.EntityWalkingMob;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.event.entity.EntityDamageByChildEntityEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector2;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.Utils;
import java.util.ArrayList;

public class EntityWitherSkeleton
extends EntityWalkingMob
implements EntitySmite {
    public static final int NETWORK_ID = 48;

    public EntityWitherSkeleton(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public int getNetworkId() {
        return 48;
    }

    @Override
    protected void initEntity() {
        this.setMaxHealth(20);
        super.initEntity();
        this.fireProof = true;
    }

    @Override
    public float getWidth() {
        return 0.7f;
    }

    @Override
    public float getHeight() {
        return 2.4f;
    }

    @Override
    public Item[] getDrops() {
        ArrayList<Item> drops = new ArrayList<Item>();
        for (int i = 0; i < Utils.rand(0, 2); ++i) {
            drops.add(Item.get(352, (Integer)0, 1));
        }
        if (Utils.rand(1, 3) == 1) {
            drops.add(Item.get(263, (Integer)0, 1));
        }
        if (Utils.rand(1, 40) == 1) {
            drops.add(Item.get(397, (Integer)1, 1));
        }
        if (Utils.rand(1, 200) <= 17) {
            drops.add(Item.get(272, (Integer)Utils.rand(0, 131), 1));
        }
        return drops.toArray(new Item[0]);
    }

    @Override
    public int getKillExperience() {
        return 5;
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.getNameTag() : "Wither Skeleton";
    }

    @Override
    public void kill() {
        Entity damager;
        if (!this.isAlive()) {
            return;
        }
        super.kill();
        if (this.lastDamageCause instanceof EntityDamageByChildEntityEvent && ((EntityDamageByChildEntityEvent)this.lastDamageCause).getChild() instanceof EntityArrow && (damager = ((EntityDamageByChildEntityEvent)this.lastDamageCause).getDamager()) instanceof Player) {
            Vector2 vector2 = new Vector2(this.x, this.z);
            Vector2 vector22 = new Vector2(damager.x, damager.z);
            if (vector2.distance(vector22) >= 50.0) {
                ((Player)damager).awardAchievement("snipeSkeleton");
            }
        }
    }
}

