/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.mob;

import cn.nukkit.block.Block;
import cn.nukkit.entity.Attribute;
import cn.nukkit.entity.EntityBoss;
import cn.nukkit.entity.EntitySmite;
import cn.nukkit.entity.mob.EntityFlyingMob;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.AddEntityPacket;
import cn.nukkit.network.protocol.DataPacket;

public class EntityWither
extends EntityFlyingMob
implements EntityBoss,
EntitySmite {
    public static final int NETWORK_ID = 52;

    public EntityWither(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public int getNetworkId() {
        return 52;
    }

    @Override
    public float getWidth() {
        return 0.9f;
    }

    @Override
    public float getHeight() {
        return 3.5f;
    }

    @Override
    public void initEntity() {
        this.setMaxHealth(this.witherMaxHealth());
        super.initEntity();
        this.fireProof = true;
    }

    @Override
    public int getKillExperience() {
        return 50;
    }

    @Override
    public Item[] getDrops() {
        return new Item[]{Item.get(399, (Integer)0, 1), Block.get(471, 0).toItem()};
    }

    @Override
    protected DataPacket createAddEntityPacket() {
        AddEntityPacket addEntity = new AddEntityPacket();
        addEntity.type = 52;
        addEntity.entityUniqueId = this.getId();
        addEntity.entityRuntimeId = this.getId();
        addEntity.yaw = (float)this.yaw;
        addEntity.headYaw = (float)this.yaw;
        addEntity.pitch = (float)this.pitch;
        addEntity.x = (float)this.x;
        addEntity.y = (float)this.y;
        addEntity.z = (float)this.z;
        addEntity.speedX = (float)this.motionX;
        addEntity.speedY = (float)this.motionY;
        addEntity.speedZ = (float)this.motionZ;
        addEntity.metadata = this.dataProperties.clone();
        addEntity.attributes = new Attribute[]{Attribute.getAttribute(4).setMaxValue(this.witherMaxHealth()).setValue(this.witherMaxHealth())};
        return addEntity;
    }

    private int witherMaxHealth() {
        switch (this.getServer().getDifficulty()) {
            case 2: {
                return 450;
            }
            case 3: {
                return 600;
            }
        }
        return 300;
    }
}

