/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.mob;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntitySmite;
import cn.nukkit.entity.mob.EntityWalkingMob;
import cn.nukkit.entity.projectile.EntityArrow;
import cn.nukkit.event.entity.EntityDamageByChildEntityEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector2;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.utils.Utils;
import java.util.ArrayList;

public class EntitySkeleton
extends EntityWalkingMob
implements EntitySmite {
    public static final int NETWORK_ID = 34;

    public EntitySkeleton(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public void initEntity() {
        this.setMaxHealth(20);
        super.initEntity();
    }

    @Override
    public int getNetworkId() {
        return 34;
    }

    @Override
    public float getWidth() {
        return 0.6f;
    }

    @Override
    public float getHeight() {
        return 1.99f;
    }

    @Override
    public Item[] getDrops() {
        int i;
        ArrayList<Item> drops = new ArrayList<Item>();
        for (i = 0; i < Utils.rand(0, 2); ++i) {
            drops.add(Item.get(352, (Integer)0, 1));
        }
        for (i = 0; i < Utils.rand(0, 2); ++i) {
            drops.add(Item.get(262, (Integer)0, 1));
        }
        return drops.toArray(new Item[0]);
    }

    @Override
    public int getKillExperience() {
        return 5;
    }

    @Override
    public void kill() {
        Entity damager;
        if (!this.isAlive()) {
            return;
        }
        super.kill();
        if (this.lastDamageCause instanceof EntityDamageByChildEntityEvent && ((EntityDamageByChildEntityEvent)this.lastDamageCause).getChild() instanceof EntityArrow && (damager = ((EntityDamageByChildEntityEvent)this.lastDamageCause).getDamager()) instanceof Player) {
            Vector2 vector2 = new Vector2(this.x, this.z);
            Vector2 vector22 = new Vector2(damager.x, damager.z);
            if (vector2.distance(vector22) >= 50.0) {
                ((Player)damager).awardAchievement("snipeSkeleton");
            }
        }
    }
}

