/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.mob;

import cn.nukkit.Player;
import cn.nukkit.entity.Attribute;
import cn.nukkit.entity.EntityBoss;
import cn.nukkit.entity.mob.EntityFlyingMob;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.AddEntityPacket;
import cn.nukkit.network.protocol.DataPacket;

public class EntityEnderDragon
extends EntityFlyingMob
implements EntityBoss {
    public static final int NETWORK_ID = 53;

    @Override
    public int getNetworkId() {
        return 53;
    }

    public EntityEnderDragon(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public float getWidth() {
        return 16.0f;
    }

    @Override
    public float getHeight() {
        return 8.0f;
    }

    @Override
    public void initEntity() {
        this.setMaxHealth(200);
        super.initEntity();
        this.fireProof = true;
        this.setDataFlag(0, 50, true);
    }

    @Override
    public int getKillExperience() {
        return 0;
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.getNameTag() : "Ender Dragon";
    }

    @Override
    protected DataPacket createAddEntityPacket() {
        AddEntityPacket addEntity = new AddEntityPacket();
        addEntity.type = 53;
        addEntity.entityUniqueId = this.getId();
        addEntity.entityRuntimeId = this.getId();
        addEntity.yaw = (float)this.yaw;
        addEntity.headYaw = (float)this.yaw;
        addEntity.pitch = (float)this.pitch;
        addEntity.x = (float)this.x;
        addEntity.y = (float)this.y;
        addEntity.z = (float)this.z;
        addEntity.speedX = (float)this.motionX;
        addEntity.speedY = (float)this.motionY;
        addEntity.speedZ = (float)this.motionZ;
        addEntity.metadata = this.dataProperties.clone();
        addEntity.attributes = new Attribute[]{Attribute.getAttribute(4).setMaxValue(200.0f).setValue(200.0f)};
        return addEntity;
    }

    @Override
    protected boolean applyNameTag(Player player, Item nameTag) {
        return false;
    }
}

