/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.nbt.tag.CompoundTag;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;

public class EntityXPOrb
extends Entity {
    public static final int NETWORK_ID = 69;
    public static final int[] ORB_SPLIT_SIZES = new int[]{2477, 1237, 617, 307, 149, 73, 37, 17, 7, 3, 1};
    public Player closestPlayer = null;
    private int pickupDelay;
    private int exp;

    public EntityXPOrb(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    public static int getMaxOrbSize(int amount) {
        for (int split : ORB_SPLIT_SIZES) {
            if (amount < split) continue;
            return split;
        }
        return 1;
    }

    public static List<Integer> splitIntoOrbSizes(int amount) {
        IntArrayList result = new IntArrayList();
        while (amount > 0) {
            int size = EntityXPOrb.getMaxOrbSize(amount);
            result.add(Integer.valueOf(size));
            amount -= size;
        }
        return result;
    }

    @Override
    public int getNetworkId() {
        return 69;
    }

    @Override
    public float getWidth() {
        return 0.1f;
    }

    @Override
    public float getLength() {
        return 0.1f;
    }

    @Override
    public float getHeight() {
        return 0.1f;
    }

    @Override
    protected float getGravity() {
        return 0.04f;
    }

    @Override
    protected float getDrag() {
        return 0.02f;
    }

    @Override
    public boolean canCollide() {
        return false;
    }

    @Override
    protected void initEntity() {
        this.setMaxHealth(5);
        super.initEntity();
        if (this.namedTag.contains("Health")) {
            this.setHealth(this.namedTag.getShort("Health"));
        } else {
            this.setHealth(5.0f);
        }
        if (this.namedTag.contains("Age")) {
            this.age = this.namedTag.getShort("Age");
        }
        if (this.namedTag.contains("PickupDelay")) {
            this.pickupDelay = this.namedTag.getShort("PickupDelay");
        }
        if (this.namedTag.contains("Value")) {
            this.exp = this.namedTag.getShort("Value");
        }
        if (this.exp <= 0) {
            this.exp = 1;
        }
        this.dataProperties.putInt(15, this.exp);
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        return (source.getCause() == EntityDamageEvent.DamageCause.VOID || source.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK || source.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || source.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) && super.attack(source);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        this.minimalEntityTick(currentTick, tickDiff);
        if (this.age > 6000) {
            this.close();
            return false;
        }
        if (this.isAlive()) {
            double dZ;
            double dY;
            double dX;
            double d;
            double diff;
            if (this.pickupDelay > 0) {
                this.pickupDelay -= tickDiff;
                if (this.pickupDelay < 0) {
                    this.pickupDelay = 0;
                }
            }
            this.motionY = this.isOnGround() ? 0.0 : (Block.isWater(this.level.getBlockIdAt(this.chunk, this.getFloorX(), NukkitMath.floorDouble(this.y + 0.53), this.getFloorZ())) ? (double)(this.getGravity() / 2.0f) : (this.motionY -= (double)this.getGravity()));
            this.checkBlockCollision();
            if (this.motionY == 0.0 && this.age % 20 == 0) {
                this.motionY = 1.0E-5;
            }
            if (this.age % 2 == 0) {
                if (this.closestPlayer != null && (this.closestPlayer.level != this.level || this.closestPlayer.closed || !this.closestPlayer.isAlive() || this.closestPlayer.isSpectator() || !this.closestPlayer.canPickupXP() || this.closestPlayer.distanceSquared(this) > 64.0)) {
                    this.closestPlayer = null;
                }
                if (this.closestPlayer == null) {
                    for (Player p : this.getViewers().values()) {
                        if (p.isSpectator() || !p.canPickupXP() || !(p.distanceSquared(this) <= 64.0)) continue;
                        this.closestPlayer = p;
                        break;
                    }
                }
            }
            if (this.closestPlayer != null && (diff = 1.0 - (d = Math.sqrt((dX = (this.closestPlayer.x - this.x) / 8.0) * dX + (dY = (this.closestPlayer.y + (double)this.closestPlayer.getEyeHeight() / 2.0 - this.y) / 8.0) * dY + (dZ = (this.closestPlayer.z - this.z) / 8.0) * dZ))) > 0.0) {
                diff *= diff;
                this.motionX += dX / d * diff * 0.1;
                this.motionY += dY / d * diff * 0.1;
                this.motionZ += dZ / d * diff * 0.1;
            }
            this.move(this.motionX, this.motionY, this.motionZ);
            if (this.y < (double)(this.getLevel().getMinBlockY() - 16)) {
                this.attack(new EntityDamageEvent((Entity)this, EntityDamageEvent.DamageCause.VOID, 10.0f));
            }
            if (this.fireTicks > 0) {
                if (this.fireProof) {
                    this.fireTicks -= tickDiff << 2;
                    if (this.fireTicks < 0) {
                        this.fireTicks = 0;
                    }
                } else {
                    if (!(this.fireTicks % 20 != 0 && tickDiff <= 20 || this.hasEffect(12))) {
                        this.attack(new EntityDamageEvent((Entity)this, EntityDamageEvent.DamageCause.FIRE_TICK, 1.0f));
                    }
                    this.fireTicks -= tickDiff;
                }
                if (this.fireTicks <= 0) {
                    this.extinguish();
                } else if (!this.fireProof) {
                    this.setDataFlag(0, 0, true);
                }
            }
            double friction = 1.0 - (double)this.getDrag();
            if (this.onGround && (Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5)) {
                friction = this.getLevel().getBlock(this.chunk, this.getFloorX(), this.getFloorY() - 1, this.getFloorZ(), false).getFrictionFactor() * friction;
            }
            this.motionX *= friction;
            this.motionY *= (double)(1.0f - this.getDrag());
            this.motionZ *= friction;
            if (this.onGround) {
                this.motionY = 0.0;
            }
        } else {
            this.close();
            return false;
        }
        this.updateMovement();
        return this.motionX != 0.0 || this.motionY != 0.0 || this.motionZ != 0.0;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putShort("Health", (int)this.getHealth());
        this.namedTag.putShort("Age", this.age);
        this.namedTag.putShort("PickupDelay", this.pickupDelay);
        this.namedTag.putShort("Value", this.exp);
    }

    public int getExp() {
        return this.exp;
    }

    public void setExp(int exp) {
        if (exp <= 0) {
            throw new IllegalArgumentException("XP amount must be greater than 0, got " + exp);
        }
        this.exp = exp;
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return false;
    }

    public int getPickupDelay() {
        return this.pickupDelay;
    }

    public void setPickupDelay(int pickupDelay) {
        this.pickupDelay = pickupDelay;
    }
}

