/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityInteractable;
import cn.nukkit.entity.EntityRideable;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.vehicle.VehicleDamageEvent;
import cn.nukkit.event.vehicle.VehicleDestroyEvent;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;

public abstract class EntityVehicle
extends Entity
implements EntityRideable,
EntityInteractable {
    private int hurtTime;
    private int hurtDirection;
    private int damage;
    protected boolean rollingDirection = true;

    public EntityVehicle(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    public int getRollingAmplitude() {
        return this.hurtTime;
    }

    public void setRollingAmplitude(int time) {
        this.hurtTime = time;
        this.setDataProperty(new IntEntityData(11, time));
    }

    public int getRollingDirection() {
        return this.hurtDirection;
    }

    public void setRollingDirection(int direction) {
        this.hurtDirection = direction;
        this.setDataProperty(new IntEntityData(12, direction));
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
        this.setDataProperty(new IntEntityData(1, damage));
    }

    @Override
    public String getInteractButtonText() {
        return "action.interact.mount";
    }

    @Override
    public boolean canDoInteraction() {
        return this.passengers.isEmpty();
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.y < (double)(this.getLevel().getMinBlockY() - 16)) {
            this.close();
        }
        if (this.closed) {
            return false;
        }
        if (this.getRollingAmplitude() > 0) {
            this.setRollingAmplitude(this.getRollingAmplitude() - 1);
        }
        this.updateMovement();
        return true;
    }

    protected boolean performHurtAnimation() {
        this.setRollingAmplitude(9);
        this.setRollingDirection(this.rollingDirection ? 1 : -1);
        this.rollingDirection = !this.rollingDirection;
        return true;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        VehicleDamageEvent event = new VehicleDamageEvent(this, source.getEntity(), source.getFinalDamage());
        this.getServer().getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return false;
        }
        boolean instantKill = false;
        if (source instanceof EntityDamageByEntityEvent) {
            Entity damager = ((EntityDamageByEntityEvent)source).getDamager();
            boolean bl = instantKill = damager instanceof Player && ((Player)damager).isCreative();
        }
        if (instantKill || this.getHealth() - source.getFinalDamage() < 1.0f) {
            VehicleDestroyEvent event2 = new VehicleDestroyEvent(this, source.getEntity());
            this.getServer().getPluginManager().callEvent(event2);
            if (event2.isCancelled()) {
                return false;
            }
        }
        if (instantKill) {
            source.setDamage(1000.0f);
        }
        return super.attack(source);
    }
}

