/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.event.potion.PotionCollideEvent;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.particle.SpellParticle;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.potion.Effect;
import cn.nukkit.potion.Potion;

public class EntityPotion
extends EntityProjectile {
    public static final int NETWORK_ID = 86;
    public int potionId;

    public EntityPotion(FullChunk chunk, CompoundTag nbt) {
        this(chunk, nbt, null);
    }

    public EntityPotion(FullChunk chunk, CompoundTag nbt, Entity shootingEntity) {
        super(chunk, nbt, shootingEntity);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.potionId = this.namedTag.getShort("PotionId");
        this.dataProperties.putShort(36, this.potionId);
        Effect effect = Potion.getEffect(this.potionId, true);
        if (effect != null) {
            int count = 0;
            int[] c = effect.getColor();
            int r = c[0] * (effect.getAmplifier() + 1) / (count += effect.getAmplifier() + 1) & 0xFF;
            int g2 = c[1] * (effect.getAmplifier() + 1) / count & 0xFF;
            int b = c[2] * (effect.getAmplifier() + 1) / count & 0xFF;
            this.setDataProperty(new IntEntityData(8, (r << 16) + (g2 << 8) + b));
        }
    }

    @Override
    public int getNetworkId() {
        return 86;
    }

    @Override
    public float getWidth() {
        return 0.25f;
    }

    @Override
    public float getLength() {
        return 0.25f;
    }

    @Override
    public float getHeight() {
        return 0.25f;
    }

    @Override
    protected float getGravity() {
        return 0.05f;
    }

    @Override
    protected float getDrag() {
        return 0.01f;
    }

    protected void splash(Entity collidedWith) {
        Entity[] entities;
        int b;
        int g2;
        int r;
        Potion potion = Potion.getPotion(this.potionId);
        PotionCollideEvent event = new PotionCollideEvent(potion, this);
        this.server.getPluginManager().callEvent(event);
        if (event.isCancelled()) {
            return;
        }
        this.close();
        potion = event.getPotion();
        if (potion == null) {
            return;
        }
        potion.setSplash(true);
        Effect effect = Potion.getEffect(potion.getId(), true);
        if (effect == null) {
            r = 40;
            g2 = 40;
            b = 255;
        } else {
            int[] colors = effect.getColor();
            r = colors[0];
            g2 = colors[1];
            b = colors[2];
        }
        SpellParticle particle = new SpellParticle(this, r, g2, b);
        this.getLevel().addParticle(particle);
        this.getLevel().addLevelSoundEvent(this, 127);
        for (Entity anEntity : entities = this.getLevel().getNearbyEntities(this.getBoundingBox().grow(4.125, 2.125, 4.125), this)) {
            double distance;
            if (anEntity == null || anEntity.closed || !anEntity.isAlive() || anEntity instanceof Player && ((Player)anEntity).isSpectator() || !((distance = anEntity.distanceSquared(this)) < 16.0)) continue;
            double d = anEntity.equals(collidedWith) ? 1.0 : 1.0 - Math.sqrt(distance) / 4.0;
            potion.applyPotion(anEntity, d);
        }
    }

    @Override
    public void onCollideWithEntity(Entity entity) {
        this.splash(entity);
        this.close();
    }

    @Override
    public boolean onUpdate(int currentTick) {
        boolean update = super.onUpdate(currentTick);
        if (this.closed) {
            return false;
        }
        if (this.isCollided) {
            this.splash(null);
        }
        if (this.age > 1200 || this.isCollided) {
            this.close();
            return false;
        }
        return update;
    }
}

