/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityHanging;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.AddPaintingPacket;
import cn.nukkit.network.protocol.DataPacket;
import java.util.HashMap;
import java.util.Map;

public class EntityPainting
extends EntityHanging {
    public static final int NETWORK_ID = 83;
    public static final Motive[] motives = Motive.values();
    private Motive motive;
    private SimpleAxisAlignedBB cachedBoundingBox;

    public EntityPainting(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    public static Motive getMotive(String name) {
        return Motive.BY_NAME.getOrDefault(name, Motive.KEBAB);
    }

    @Override
    public int getNetworkId() {
        return 83;
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        this.motive = EntityPainting.getMotive(this.namedTag.getString("Motive"));
    }

    @Override
    public DataPacket createAddEntityPacket() {
        AddPaintingPacket addPainting = new AddPaintingPacket();
        addPainting.entityUniqueId = this.getId();
        addPainting.entityRuntimeId = this.getId();
        addPainting.x = (float)this.x;
        addPainting.y = (float)this.y;
        addPainting.z = (float)this.z;
        addPainting.direction = this.getDirection().getHorizontalIndex();
        addPainting.title = this.namedTag.getString("Motive");
        return addPainting;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        if (super.attack(source)) {
            Entity damager;
            if (source instanceof EntityDamageByEntityEvent && (damager = ((EntityDamageByEntityEvent)source).getDamager()) instanceof Player && ((Player)damager).isSurvival()) {
                this.dropItem();
            }
            this.level.addParticle(new DestroyBlockParticle(this, Block.get(5)));
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putString("Motive", this.motive.title);
    }

    public Motive getArt() {
        return this.getMotive();
    }

    public Motive getMotive() {
        return (Motive)((Object)Motive.BY_NAME.get(this.namedTag.getString("Motive")));
    }

    @Override
    protected boolean isSurfaceValid() {
        if (this.cachedBoundingBox == null) {
            this.cachedBoundingBox = new SimpleAxisAlignedBB(this.x - 0.1, this.y, this.z - 0.1, this.x + 0.1, this.y + 0.1, this.z + 0.1);
        }
        return this.level.hasCollisionBlocks(this, this.cachedBoundingBox);
    }

    @Override
    protected void dropItem() {
        if (this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
            this.level.dropItem(this, Item.get(321));
        }
    }

    @Override
    public boolean ignoredAsSaveReason() {
        return true;
    }

    public static enum Motive {
        KEBAB("Kebab", 1, 1),
        AZTEC("Aztec", 1, 1),
        ALBAN("Alban", 1, 1),
        AZTEC2("Aztec2", 1, 1),
        BOMB("Bomb", 1, 1),
        PLANT("Plant", 1, 1),
        WASTELAND("Wasteland", 1, 1),
        WANDERER("Wanderer", 1, 2),
        GRAHAM("Graham", 1, 2),
        POOL("Pool", 2, 1),
        COURBET("Courbet", 2, 1),
        SUNSET("Sunset", 2, 1),
        SEA("Sea", 2, 1),
        CREEBET("Creebet", 2, 1),
        MATCH("Match", 2, 2),
        BUST("Bust", 2, 2),
        STAGE("Stage", 2, 2),
        VOID("Void", 2, 2),
        SKULL_AND_ROSES("SkullAndRoses", 2, 2),
        WITHER("Wither", 2, 2),
        FIGHTERS("Fighters", 4, 2),
        SKELETON("Skeleton", 4, 3),
        DONKEY_KONG("DonkeyKong", 4, 3),
        POINTER("Pointer", 4, 4),
        PIG_SCENE("Pigscene", 4, 4),
        BURNING_SKULL("BurningSkull", 4, 4);

        public final String title;
        public final int width;
        public final int height;
        private static final Map<String, Motive> BY_NAME;

        private Motive(String title, int width, int height) {
            this.title = title;
            this.width = width;
            this.height = height;
        }

        static {
            BY_NAME = new HashMap<String, Motive>();
            for (Motive motive : Motive.values()) {
                BY_NAME.put(motive.title, motive);
            }
        }
    }
}

