/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockComposter;
import cn.nukkit.block.BlockRailActivator;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityContainer;
import cn.nukkit.blockentity.BlockEntityFurnace;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.entity.item.EntityMinecartAbstract;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.inventory.InventoryMoveItemEvent;
import cn.nukkit.inventory.FurnaceInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.MinecartHopperInventory;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.MinecartType;

public class EntityMinecartHopper
extends EntityMinecartAbstract
implements InventoryHolder {
    public static final int NETWORK_ID = 96;
    protected MinecartHopperInventory inventory;
    public int transferCooldown;

    public EntityMinecartHopper(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
        this.setDisplayBlock(Block.get(154), false);
        this.setName("Minecart with Hopper");
    }

    @Override
    public MinecartType getType() {
        return MinecartType.valueOf(5);
    }

    @Override
    public boolean isRideable() {
        return false;
    }

    @Override
    public int getNetworkId() {
        return 96;
    }

    @Override
    public void dropItem() {
        Entity damager;
        if (this.lastDamageCause instanceof EntityDamageByEntityEvent && (damager = ((EntityDamageByEntityEvent)this.lastDamageCause).getDamager()) instanceof Player && ((Player)damager).isCreative()) {
            return;
        }
        this.level.dropItem(this, Item.get(408));
        if (this.inventory != null) {
            this.inventory.getViewers().clear();
            for (Item item : this.inventory.getContents().values()) {
                this.level.dropItem(this, item);
            }
            this.inventory.clearAll();
        }
    }

    @Override
    public boolean mountEntity(Entity entity, byte mode) {
        return false;
    }

    @Override
    public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        if (this.isAlive()) {
            player.addWindow(this.inventory);
        }
        return false;
    }

    @Override
    public MinecartHopperInventory getInventory() {
        return this.inventory;
    }

    @Override
    public void initEntity() {
        super.initEntity();
        this.inventory = new MinecartHopperInventory(this);
        if (this.namedTag.contains("Items") && this.namedTag.get("Items") instanceof ListTag) {
            ListTag<CompoundTag> inventoryList = this.namedTag.getList("Items", CompoundTag.class);
            for (CompoundTag item : inventoryList.getAll()) {
                this.inventory.setItem(item.getByte("Slot"), NBTIO.getItemHelper(item));
            }
        }
        this.dataProperties.putByte(44, 11).putInt(45, this.inventory.getSize()).putInt(46, 0);
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putList(new ListTag("Items"));
        if (this.inventory != null) {
            for (int slot = 0; slot < 5; ++slot) {
                Item item = this.inventory.getItem(slot);
                if (item == null || item.getId() == 0) continue;
                this.namedTag.getList("Items", CompoundTag.class).add(NBTIO.putItemHelper(item, slot));
            }
        }
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (super.onUpdate(currentTick) && !this.closed && this.isAlive()) {
            if (this.isOnTransferCooldown()) {
                --this.transferCooldown;
                return true;
            }
            Block rail = this.level.getBlock(this.chunk, this.getFloorX(), this.getFloorY(), this.getFloorZ(), false);
            if (rail instanceof BlockRailActivator && ((BlockRailActivator)rail).isActive()) {
                return false;
            }
            BlockEntity blockEntity = this.level.getBlockEntity(this.chunk, this.up());
            Block block = null;
            boolean changed = blockEntity instanceof BlockEntityContainer || (block = this.level.getBlock(this.chunk, this.getFloorX(), this.getFloorY() + 1, this.getFloorZ(), false)) instanceof BlockComposter ? this.pullItems(blockEntity, block) : this.pickupItems(new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0, this.y + 2.0, this.z + 1.0));
            if (changed) {
                this.setTransferCooldown(8);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getInteractButtonText() {
        return "action.interact.opencontainer";
    }

    public boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public void setTransferCooldown(int transferCooldown) {
        this.transferCooldown = transferCooldown;
    }

    private boolean pullItems(BlockEntity blockEntity, Block block) {
        if (this.inventory.isFull()) {
            return false;
        }
        if (blockEntity instanceof BlockEntityFurnace) {
            FurnaceInventory inv = ((BlockEntityFurnace)blockEntity).getInventory();
            Item item = inv.getResult();
            if (!item.isNull()) {
                Item itemToAdd = item.clone();
                itemToAdd.count = 1;
                if (!this.inventory.canAddItem(itemToAdd)) {
                    return false;
                }
                InventoryMoveItemEvent ev = new InventoryMoveItemEvent(inv, this.inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return false;
                }
                Item[] items = this.inventory.addItem(itemToAdd);
                if (items.length == 0) {
                    --item.count;
                    inv.setResult(item);
                    return true;
                }
            }
        } else if (blockEntity instanceof InventoryHolder) {
            Inventory inv = ((InventoryHolder)((Object)blockEntity)).getInventory();
            for (int i = 0; i < inv.getSize(); ++i) {
                Item[] items;
                Item item = inv.getItem(i);
                if (item.isNull()) continue;
                Item itemToAdd = item.clone();
                itemToAdd.count = 1;
                if (!this.inventory.canAddItem(itemToAdd)) continue;
                InventoryMoveItemEvent ev = new InventoryMoveItemEvent(inv, this.inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled() || (items = this.inventory.addItem(itemToAdd)).length >= 1) continue;
                --item.count;
                inv.setItem(i, item);
                return true;
            }
        } else if (block instanceof BlockComposter) {
            BlockComposter composter = (BlockComposter)block;
            Item item = composter.empty();
            if (item == null || item.isNull()) {
                return false;
            }
            Item itemToAdd = item.clone();
            itemToAdd.setCount(1);
            if (!this.inventory.canAddItem(itemToAdd)) {
                return false;
            }
            InventoryMoveItemEvent ev = new InventoryMoveItemEvent(null, this.inventory, this, item, InventoryMoveItemEvent.Action.PICKUP);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
            Item[] items = this.inventory.addItem(itemToAdd);
            return items.length == 0;
        }
        return false;
    }

    private boolean pickupItems(AxisAlignedBB pickupArea) {
        if (this.inventory.isFull()) {
            return false;
        }
        boolean pickedUpItem = false;
        for (Entity entity : this.level.getCollidingEntities(pickupArea)) {
            EntityItem itemEntity;
            Item item;
            if (entity.isClosed() || !(entity instanceof EntityItem) || (item = (itemEntity = (EntityItem)entity).getItem()).isNull()) continue;
            int originalCount = item.getCount();
            if (!this.inventory.canAddItem(item)) continue;
            InventoryMoveItemEvent ev = new InventoryMoveItemEvent(null, this.inventory, this, item, InventoryMoveItemEvent.Action.PICKUP);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) continue;
            Item[] items = this.inventory.addItem(item);
            if (items.length == 0) {
                entity.close();
                pickedUpItem = true;
                continue;
            }
            if (items[0].getCount() == originalCount) continue;
            pickedUpItem = true;
            item.setCount(items[0].getCount());
        }
        return pickedUpItem;
    }
}

