/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityMinecartAbstract;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.MinecartChestInventory;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.utils.MinecartType;

public class EntityMinecartChest
extends EntityMinecartAbstract
implements InventoryHolder {
    public static final int NETWORK_ID = 98;
    protected MinecartChestInventory inventory;

    public EntityMinecartChest(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
        this.setDisplayBlock(Block.get(54), false);
        this.setName("Minecart with Chest");
    }

    @Override
    public MinecartType getType() {
        return MinecartType.valueOf(1);
    }

    @Override
    public boolean isRideable() {
        return false;
    }

    @Override
    public int getNetworkId() {
        return 98;
    }

    @Override
    public void dropItem() {
        Entity damager;
        if (this.lastDamageCause instanceof EntityDamageByEntityEvent && (damager = ((EntityDamageByEntityEvent)this.lastDamageCause).getDamager()) instanceof Player && ((Player)damager).isCreative()) {
            return;
        }
        this.level.dropItem(this, Item.get(342));
        if (this.inventory == null) {
            this.initInventory();
        }
        if (this.inventory != null) {
            this.inventory.getViewers().clear();
            for (Item item : this.inventory.getContents().values()) {
                this.level.dropItem(this, item);
            }
            this.inventory.clearAll();
        }
    }

    @Override
    public boolean mountEntity(Entity entity, byte mode) {
        return false;
    }

    @Override
    public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        if (this.isAlive()) {
            player.addWindow(this.getInventory());
        }
        return false;
    }

    @Override
    public MinecartChestInventory getInventory() {
        if (this.inventory == null) {
            this.initInventory();
        }
        return this.inventory;
    }

    @Override
    public void initEntity() {
        super.initEntity();
        this.dataProperties.putByte(44, 10).putInt(45, 27).putInt(46, 0);
    }

    private void initInventory() {
        if (!this.namedTag.contains("Items") || !(this.namedTag.get("Items") instanceof ListTag)) {
            this.namedTag.putList(new ListTag("Items"));
        }
        ListTag<? extends Tag> list = this.namedTag.getList("Items");
        this.inventory = new MinecartChestInventory(this);
        for (CompoundTag compoundTag : list.getAll()) {
            Item item = NBTIO.getItemHelper(compoundTag);
            if (item.getId() == 0 || item.getCount() <= 0) continue;
            this.inventory.slots.put(compoundTag.getByte("Slot"), item);
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        if (this.inventory != null) {
            this.namedTag.putList(new ListTag("Items"));
            for (int slot = 0; slot < 27; ++slot) {
                Item item = this.inventory.getItem(slot);
                if (item == null || item.getId() == 0) continue;
                this.namedTag.getList("Items", CompoundTag.class).add(NBTIO.putItemHelper(item, slot));
            }
        }
    }

    @Override
    public String getInteractButtonText() {
        return "action.interact.opencontainer";
    }
}

