/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.entity.Entity;
import cn.nukkit.entity.data.NBTEntityData;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.entity.EntityExplosionPrimeEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemFirework;
import cn.nukkit.level.Explosion;
import cn.nukkit.level.Position;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.network.protocol.EntityEventPacket;
import java.util.concurrent.ThreadLocalRandom;

public class EntityFirework
extends Entity {
    public static final int NETWORK_ID = 72;
    private int lifetime;
    private Item firework;

    public EntityFirework(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public void initEntity() {
        super.initEntity();
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        this.motionX = rand.nextGaussian() * 0.001;
        this.motionZ = rand.nextGaussian() * 0.001;
        this.motionY = 0.05;
        if (this.namedTag.contains("FireworkItem")) {
            this.setFirework(NBTIO.getItemHelper(this.namedTag.getCompound("FireworkItem")));
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        if (this.firework != null) {
            this.namedTag.putCompound("FireworkItem", NBTIO.putItemHelper(this.firework));
        }
    }

    @Override
    public int getNetworkId() {
        return 72;
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        if (this.age > this.lifetime) {
            this.close();
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        this.lastUpdate = currentTick;
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        if (this.isAlive()) {
            this.motionX *= 1.15;
            this.motionZ *= 1.15;
            this.motionY += 0.04;
            this.move(this.motionX, this.motionY, this.motionZ);
            this.updateMovement();
            float f = (float)Math.sqrt(this.motionX * this.motionX + this.motionZ * this.motionZ);
            this.yaw = (float)(Math.atan2(this.motionX, this.motionZ) * 57.29577951308232);
            this.pitch = (float)(Math.atan2(this.motionY, f) * 57.29577951308232);
            if (this.age == 0) {
                this.getLevel().addLevelSoundEvent(this, 56);
            }
            if (this.age >= this.lifetime) {
                Tag nbt;
                EntityEventPacket pk = new EntityEventPacket();
                pk.event = 25;
                pk.eid = this.getId();
                this.level.addChunkPacket(this.getChunkX(), this.getChunkZ(), pk);
                this.level.addLevelSoundEvent(this, 58, -1, 72);
                if (this.firework != null && (nbt = this.firework.getNamedTag()) != null && (nbt = ((CompoundTag)nbt).get("Fireworks")) instanceof CompoundTag && (nbt = ((CompoundTag)nbt).get("Explosions")) instanceof ListTag && ((ListTag)nbt).size() != 0) {
                    EntityExplosionPrimeEvent ev = new EntityExplosionPrimeEvent(this, 2.5);
                    ev.setBlockBreaking(false);
                    this.server.getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        Explosion explosion = new Explosion((Position)this, ev.getForce(), this);
                        explosion.explodeEntity();
                    }
                }
                this.kill();
                hasUpdate = true;
            }
        }
        return hasUpdate || !this.onGround || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        return (source.getCause() == EntityDamageEvent.DamageCause.VOID || source.getCause() == EntityDamageEvent.DamageCause.FIRE_TICK || source.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || source.getCause() == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) && super.attack(source);
    }

    public void setFirework(Item item) {
        this.firework = item;
        this.setDataProperty(new NBTEntityData(16, this.firework));
        int level = Math.max(1, this.firework instanceof ItemFirework ? ((ItemFirework)this.firework).getFlight() : 1);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        this.lifetime = 10 * (level + 1) + rand.nextInt(5) + rand.nextInt(6);
    }

    @Override
    public float getWidth() {
        return 0.25f;
    }

    @Override
    public float getHeight() {
        return 0.25f;
    }
}

