/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.data.IntEntityData;
import cn.nukkit.event.entity.EntityBlockChangeEvent;
import cn.nukkit.event.entity.EntityDamageByBlockEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.GlobalBlockPalette;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;

public class EntityFallingBlock
extends Entity {
    public static final int NETWORK_ID = 66;
    protected int blockId;
    protected int damage;

    @Override
    public float getWidth() {
        return 0.98f;
    }

    @Override
    public float getLength() {
        return 0.98f;
    }

    @Override
    public float getHeight() {
        return 0.98f;
    }

    @Override
    protected float getGravity() {
        return 0.04f;
    }

    @Override
    protected float getDrag() {
        return 0.02f;
    }

    @Override
    protected float getBaseOffset() {
        return 0.49f;
    }

    @Override
    public boolean canCollide() {
        return this.blockId == 145;
    }

    public EntityFallingBlock(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initEntity() {
        super.initEntity();
        if (this.namedTag != null) {
            if (this.namedTag.contains("TileID")) {
                this.blockId = this.namedTag.getInt("TileID");
            } else if (this.namedTag.contains("Tile")) {
                this.blockId = this.namedTag.getInt("Tile");
                this.namedTag.putInt("TileID", this.blockId);
            }
            if (this.namedTag.contains("Data")) {
                this.damage = this.namedTag.getByte("Data");
            }
        }
        if (this.blockId == 0) {
            this.close();
            return;
        }
        this.fireProof = true;
        this.setDataProperty(new IntEntityData(2, GlobalBlockPalette.getOrCreateRuntimeId(this.blockId, this.damage)));
    }

    @Override
    public boolean canCollideWith(Entity entity) {
        return this.blockId == 145 || this.blockId == 563;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        return source.getCause() == EntityDamageEvent.DamageCause.VOID && super.attack(source);
    }

    @Override
    public boolean onUpdate(int currentTick) {
        boolean hasUpdate;
        block12: {
            block13: {
                block16: {
                    Block floorBlock;
                    block14: {
                        int mergedHeight;
                        block15: {
                            if (this.closed) {
                                return false;
                            }
                            int tickDiff = currentTick - this.lastUpdate;
                            if (tickDiff <= 0 && !this.justCreated) {
                                return true;
                            }
                            this.lastUpdate = currentTick;
                            hasUpdate = this.entityBaseTick(tickDiff);
                            if (!this.isAlive()) break block12;
                            this.motionY -= (double)this.getGravity();
                            this.move(this.motionX, this.motionY, this.motionZ);
                            float friction = 1.0f - this.getDrag();
                            this.motionX *= (double)friction;
                            this.motionY *= (double)(1.0f - this.getDrag());
                            this.motionZ *= (double)friction;
                            if (!this.onGround || this.closed) break block13;
                            this.close();
                            floorBlock = this.level.getBlock(this.add(0.0, 1.0E-4, 0.0));
                            if (this.getBlock() != 78 || floorBlock.getId() != 78 || (floorBlock.getDamage() & 7) == 7) break block14;
                            mergedHeight = (floorBlock.getDamage() & 7) + 1 + (this.getDamage() & 7) + 1;
                            if (mergedHeight <= 8) break block15;
                            EntityBlockChangeEvent event = new EntityBlockChangeEvent(this, floorBlock, Block.get(78, 7));
                            this.server.getPluginManager().callEvent(event);
                            if (event.isCancelled()) break block16;
                            this.level.setBlock(floorBlock, event.getTo(), true);
                            Vector3 abovePos = floorBlock.getSideVec(BlockFace.UP);
                            Block aboveBlock = this.level.getBlock(abovePos);
                            if (aboveBlock.getId() != 0) break block16;
                            EntityBlockChangeEvent event2 = new EntityBlockChangeEvent(this, aboveBlock, Block.get(78, mergedHeight - 9));
                            this.server.getPluginManager().callEvent(event2);
                            if (event2.isCancelled()) break block16;
                            this.level.setBlock(abovePos, event2.getTo(), true);
                            break block16;
                        }
                        EntityBlockChangeEvent event = new EntityBlockChangeEvent(this, floorBlock, Block.get(78, mergedHeight - 1));
                        this.server.getPluginManager().callEvent(event);
                        if (event.isCancelled()) break block16;
                        this.level.setBlock(floorBlock, event.getTo(), true);
                        break block16;
                    }
                    if (floorBlock.isTransparent() && !floorBlock.canBeReplaced() || this.getBlock() == 78 && floorBlock instanceof BlockLiquid) {
                        if (this.getBlock() != 78 ? this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS) : this.level.getGameRules().getBoolean(GameRule.DO_TILE_DROPS)) {
                            this.getLevel().dropItem(this, Item.get(this.blockId, (Integer)this.damage, 1));
                        }
                    } else if (floorBlock.canBeReplaced()) {
                        EntityBlockChangeEvent event = new EntityBlockChangeEvent(this, floorBlock, Block.get(this.blockId, this.damage));
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            int blockId = event.getTo().getId();
                            if (blockId != 563) {
                                this.getLevel().setBlock(floorBlock, event.getTo(), true, true);
                            }
                            if (blockId == 145 || blockId == 563) {
                                Entity[] e;
                                if (blockId == 145) {
                                    this.getLevel().addLevelEvent(this, 1022);
                                } else {
                                    this.getLevel().dropItem(this, Block.get(blockId, event.getTo().getDamage()).toItem());
                                }
                                for (Entity entity : e = this.level.getCollidingEntities(this.getBoundingBox(), this)) {
                                    if (!(entity instanceof EntityLiving) || !(this.highestPosition > this.y)) continue;
                                    entity.attack(new EntityDamageByBlockEvent(event.getTo(), entity, EntityDamageEvent.DamageCause.CONTACT, (float)Math.min(40.0, Math.max(0.0, (this.highestPosition - this.y) * 2.0))));
                                }
                            }
                        }
                    }
                }
                hasUpdate = true;
            }
            this.updateMovement();
        }
        return hasUpdate || !this.onGround || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }

    public int getBlock() {
        return this.blockId;
    }

    public int getDamage() {
        return this.damage;
    }

    @Override
    public int getNetworkId() {
        return 66;
    }

    @Override
    public void saveNBT() {
        this.namedTag.putInt("TileID", this.blockId);
        this.namedTag.putByte("Data", this.damage);
    }

    @Override
    public boolean canBeMovedByCurrents() {
        return false;
    }

    @Override
    public void resetFallDistance() {
        if (!this.closed) {
            this.highestPosition = this.y;
        }
    }
}

