/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.entity.item.EntityBoat;
import cn.nukkit.inventory.ChestBoatInventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.InventoryType;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;

public class EntityChestBoat
extends EntityBoat
implements InventoryHolder {
    public static final int NETWORK_ID = 218;
    protected ChestBoatInventory inventory;

    public EntityChestBoat(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public int getNetworkId() {
        return 218;
    }

    @Override
    public String getName() {
        return "Boat with Chest";
    }

    @Override
    public String getInteractButtonText(Player player) {
        if (player.sneakToBlockInteract()) {
            return "action.interact.opencontainer";
        }
        return super.getInteractButtonText();
    }

    @Override
    public boolean isFull() {
        return !this.passengers.isEmpty();
    }

    @Override
    public ChestBoatInventory getInventory() {
        if (this.inventory == null) {
            this.initInventory();
        }
        return this.inventory;
    }

    @Override
    public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        if (player.sneakToBlockInteract() && this.isAlive()) {
            player.addWindow(this.getInventory());
            return false;
        }
        return super.onInteract(player, item, clickedPos);
    }

    @Override
    public void initEntity() {
        super.initEntity();
        this.dataProperties.putByte(44, InventoryType.CHEST_BOAT.getNetworkType()).putInt(45, 27).putInt(46, 0);
    }

    private void initInventory() {
        if (!this.namedTag.contains("Items") || !(this.namedTag.get("Items") instanceof ListTag)) {
            this.namedTag.putList(new ListTag("Items"));
        }
        ListTag<? extends Tag> list = this.namedTag.getList("Items");
        this.inventory = new ChestBoatInventory(this);
        for (CompoundTag compoundTag : list.getAll()) {
            Item item = NBTIO.getItemHelper(compoundTag);
            if (item.getId() == 0 || item.getCount() <= 0) continue;
            this.inventory.slots.put(compoundTag.getByte("Slot"), item);
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        if (this.inventory != null) {
            this.namedTag.putList(new ListTag("Items"));
            for (int slot = 0; slot < 27; ++slot) {
                Item item = this.inventory.getItem(slot);
                if (item == null || item.getId() == 0) continue;
                this.namedTag.getList("Items", CompoundTag.class).add(NBTIO.putItemHelper(item, slot));
            }
        }
    }

    @Override
    protected void dropItem() {
        switch (this.getVariant()) {
            case 0: {
                this.level.dropItem(this, Item.get(638));
                break;
            }
            case 1: {
                this.level.dropItem(this, Item.get(641));
                break;
            }
            case 2: {
                this.level.dropItem(this, Item.get(639));
                break;
            }
            case 3: {
                this.level.dropItem(this, Item.get(640));
                break;
            }
            case 4: {
                this.level.dropItem(this, Item.get(642));
                break;
            }
            case 5: {
                this.level.dropItem(this, Item.get(643));
                break;
            }
            case 6: {
                this.level.dropItem(this, Item.get(644));
            }
        }
        if (this.inventory == null) {
            this.initInventory();
        }
        if (this.inventory != null) {
            this.inventory.getViewers().clear();
            for (Item item : this.inventory.getContents().values()) {
                this.level.dropItem(this, item);
            }
            this.inventory.clearAll();
        }
    }
}

