/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockWater;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityLiving;
import cn.nukkit.entity.data.ByteEntityData;
import cn.nukkit.entity.data.FloatEntityData;
import cn.nukkit.entity.item.EntityVehicle;
import cn.nukkit.entity.passive.EntityWaterAnimal;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.event.vehicle.VehicleMoveEvent;
import cn.nukkit.event.vehicle.VehicleUpdateEvent;
import cn.nukkit.item.Item;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.Location;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.math.Vector3;
import cn.nukkit.math.Vector3f;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.network.protocol.AnimatePacket;
import java.util.ArrayList;

public class EntityBoat
extends EntityVehicle {
    public static final int NETWORK_ID = 90;
    public static final Vector3f RIDER_PLAYER_OFFSET = new Vector3f(0.0f, 1.02001f, 0.0f);
    public static final Vector3f RIDER_OFFSET = new Vector3f(0.0f, -0.2f, 0.0f);
    public static final Vector3f PASSENGER_OFFSET = new Vector3f(-0.6f);
    public static final Vector3f RIDER_PASSENGER_OFFSET = new Vector3f(0.2f);
    public static final int RIDER_INDEX = 0;
    public static final int PASSENGER_INDEX = 1;
    public static final double SINKING_DEPTH = 0.07;
    public static final double SINKING_SPEED = 5.0E-4;
    public static final double SINKING_MAX_SPEED = 0.005;
    protected boolean sinking = true;
    public int woodID;

    public EntityBoat(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initEntity() {
        this.setMaxHealth(40);
        super.initEntity();
        this.setHealth(40.0f);
        if (this.namedTag.contains("Variant")) {
            this.woodID = this.namedTag.getInt("Variant");
        }
        this.dataProperties.putInt(2, this.woodID);
        this.dataProperties.putBoolean(119, true);
        this.dataProperties.putString(121, "{\"apply_gravity\":true,\"base_buoyancy\":1.0,\"big_wave_probability\":0.02999999932944775,\"big_wave_speed\":10.0,\"drag_down_on_buoyancy_removed\":0.0,\"liquid_blocks\":[\"minecraft:water\",\"minecraft:flowing_water\"],\"simulate_waves\":true}");
    }

    @Override
    public float getHeight() {
        return 0.455f;
    }

    @Override
    public float getWidth() {
        return 1.4f;
    }

    @Override
    protected float getDrag() {
        return 0.1f;
    }

    @Override
    protected float getGravity() {
        return 0.04f;
    }

    @Override
    public float getBaseOffset() {
        return 0.375f;
    }

    @Override
    public int getNetworkId() {
        return 90;
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        if (this.invulnerable) {
            return false;
        }
        source.setDamage(source.getDamage() * 2.0f);
        boolean attack = super.attack(source);
        if (this.isAlive()) {
            this.performHurtAnimation();
        }
        return attack;
    }

    @Override
    public void close() {
        super.close();
        if (!this.passengers.isEmpty()) {
            for (Entity passenger : new ArrayList(this.passengers)) {
                this.dismountEntity(passenger);
                passenger.riding = null;
            }
        }
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        int tickDiff = currentTick - this.lastUpdate;
        if (tickDiff <= 0 && !this.justCreated) {
            return true;
        }
        this.lastUpdate = currentTick;
        boolean hasUpdate = this.entityBaseTick(tickDiff);
        if (this.isAlive()) {
            super.onUpdate(currentTick);
            double waterDiff = this.getWaterLevel();
            if (!this.hasControllingPassenger()) {
                if (waterDiff > 0.07 && !this.sinking) {
                    this.sinking = true;
                } else if (waterDiff < -0.07 && this.sinking) {
                    this.sinking = false;
                }
                if (waterDiff < -0.07) {
                    this.motionY = Math.min(0.05, this.motionY + 0.005);
                } else if (waterDiff < 0.0 || !this.sinking) {
                    double d = this.motionY = this.motionY > 0.005 ? Math.max(this.motionY - 0.02, 0.005) : this.motionY + 5.0E-4;
                }
            }
            if (this.checkObstruction(this.x, this.y, this.z)) {
                hasUpdate = true;
            }
            double friction = 1.0f - this.getDrag();
            if (this.onGround && (Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5)) {
                friction *= this.getLevel().getBlock(this.chunk, this.getFloorX(), this.getFloorY() - 1, this.getFloorZ(), false).getFrictionFactor();
            }
            this.motionX *= friction;
            if (!this.hasControllingPassenger() && (waterDiff > 0.07 || this.sinking)) {
                this.motionY = waterDiff > 0.5 ? this.motionY - (double)this.getGravity() : (this.motionY - 5.0E-4 < -0.005 ? this.motionY : this.motionY - 5.0E-4);
            }
            this.motionZ *= friction;
            Location from = new Location(this.lastX, this.lastY, this.lastZ, this.lastYaw, this.lastPitch, this.level);
            Location to = new Location(this.x, this.y, this.z, this.yaw, this.pitch, this.level);
            this.getServer().getPluginManager().callEvent(new VehicleUpdateEvent(this));
            if (!from.equals(to)) {
                this.getServer().getPluginManager().callEvent(new VehicleMoveEvent(this, from, to));
            }
            this.move(this.motionX, this.motionY, this.motionZ);
            this.updateMovement();
            if (this.age % 5 == 0 && !this.passengers.isEmpty() && this.passengers.get(0) instanceof Player) {
                Block[] blocks;
                for (Block b : blocks = this.level.getCollisionBlocks(this.getBoundingBox().grow(0.1, 0.3, 0.1))) {
                    if (b.getId() != 111) continue;
                    this.level.setBlockAt((int)b.x, (int)b.y, (int)b.z, 0, 0);
                    this.level.dropItem(b, Item.get(111, (Integer)0, 1));
                }
            }
        }
        return hasUpdate || !this.onGround || Math.abs(this.motionX) > 1.0E-5 || Math.abs(this.motionY) > 1.0E-5 || Math.abs(this.motionZ) > 1.0E-5;
    }

    @Override
    public void updatePassengers() {
        this.updatePassengers(false);
    }

    public void updatePassengers(boolean sendLinks) {
        Entity ent;
        if (this.passengers.isEmpty()) {
            return;
        }
        for (Entity passenger : new ArrayList(this.passengers)) {
            if (passenger.isAlive()) continue;
            this.dismountEntity(passenger);
        }
        if (this.passengers.size() == 1) {
            ent = (Entity)this.passengers.get(0);
            ent.setSeatPosition(this.getMountedOffset(ent));
            super.updatePassengerPosition(ent);
            if (sendLinks) {
                this.broadcastLinkPacket(ent, (byte)1);
            }
        } else if (this.passengers.size() == 2) {
            Entity passenger2;
            ent = (Entity)this.passengers.get(0);
            if (!(ent instanceof Player) && (passenger2 = (Entity)this.passengers.get(1)) instanceof Player) {
                this.passengers.set(0, passenger2);
                this.passengers.set(1, ent);
                ent = passenger2;
            }
            ent.setSeatPosition(this.getMountedOffset(ent).add(RIDER_PASSENGER_OFFSET));
            super.updatePassengerPosition(ent);
            if (sendLinks) {
                this.broadcastLinkPacket(ent, (byte)1);
            }
            ent = (Entity)this.passengers.get(1);
            ent.setSeatPosition(this.getMountedOffset(ent).add(PASSENGER_OFFSET));
            super.updatePassengerPosition(ent);
            if (sendLinks) {
                this.broadcastLinkPacket(ent, (byte)2);
            }
            float yawDiff = ent.getId() % 2L == 0L ? 90.0f : 270.0f;
            ent.setRotation(this.yaw + (double)yawDiff, ent.pitch);
            ent.updateMovement();
        } else {
            for (Entity passenger : this.passengers) {
                super.updatePassengerPosition(passenger);
            }
        }
    }

    public double getWaterLevel() {
        final double maxY = this.boundingBox.getMinY() + (double)this.getBaseOffset();
        AxisAlignedBB.BBConsumer<Double> consumer = new AxisAlignedBB.BBConsumer<Double>(){
            private double diffY = Double.MAX_VALUE;

            @Override
            public void accept(int x, int y, int z) {
                Block block = EntityBoat.this.level.getBlock(EntityBoat.this.temporalVector.setComponents(x, y, z));
                if (block instanceof BlockWater) {
                    this.diffY = Math.min(maxY - block.getMaxY(), this.diffY);
                }
            }

            @Override
            public Double get() {
                return this.diffY;
            }
        };
        this.boundingBox.forEach(consumer);
        return (Double)consumer.get();
    }

    @Override
    public boolean mountEntity(Entity entity, byte mode) {
        boolean r;
        boolean player = !this.passengers.isEmpty() && this.passengers.get(0) instanceof Player;
        mode = (byte)2;
        if (!player && (entity instanceof Player || this.passengers.isEmpty())) {
            mode = 1;
        }
        if (r = super.mountEntity(entity, mode)) {
            this.updatePassengers(true);
            entity.setDataProperty(new ByteEntityData(57, 1), !(entity instanceof Player));
            if (entity instanceof Player) {
                entity.setDataProperty(new FloatEntityData(58, 90.0f), false);
                entity.setDataProperty(new FloatEntityData(59, 1.0f), false);
                entity.setDataProperty(new FloatEntityData(60, -90.0f), false);
                entity.sendData((Player)entity);
            }
        }
        return r;
    }

    @Override
    protected void updatePassengerPosition(Entity passenger) {
        this.updatePassengers();
    }

    @Override
    public boolean dismountEntity(Entity entity, boolean sendLinks) {
        boolean r = super.dismountEntity(entity, sendLinks);
        if (r) {
            this.updatePassengers();
            entity.setDataProperty(new ByteEntityData(57, 0), true);
        }
        return r;
    }

    @Override
    public boolean isControlling(Entity entity) {
        return entity instanceof Player && this.passengers.indexOf(entity) == 0;
    }

    @Override
    public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        if (this.isFull() || this.getWaterLevel() < -0.07) {
            return false;
        }
        this.mountEntity(player);
        return super.onInteract(player, item, clickedPos);
    }

    @Override
    public Vector3f getMountedOffset(Entity entity) {
        return entity instanceof Player ? RIDER_PLAYER_OFFSET : RIDER_OFFSET;
    }

    public void onPaddle(AnimatePacket.Action animation, float value) {
        int propertyId;
        int n = propertyId = animation == AnimatePacket.Action.ROW_RIGHT ? 14 : 13;
        if (this.getDataPropertyFloat(propertyId) != value) {
            this.setDataProperty(new FloatEntityData(propertyId, value));
        }
    }

    @Override
    public void applyEntityCollision(Entity entity) {
        if (entity instanceof Player && entity.riding != this) {
            ((Player)entity).resetInAirTicks();
        }
        if (this.passengers.size() < 2 && entity.riding == null && entity instanceof EntityLiving && !(entity instanceof Player) && !(entity instanceof EntityWaterAnimal) && !this.isPassenger(entity)) {
            this.mountEntity(entity);
        }
        if (this.riding == null && entity.riding != this && !entity.passengers.contains(this)) {
            if (!entity.boundingBox.intersectsWith(this.boundingBox.grow(0.2f, -0.1, 0.2f)) || entity instanceof Player && ((Player)entity).getGamemode() == 3) {
                return;
            }
            double diffX = entity.x - this.x;
            double diffZ = entity.z - this.z;
            double direction = NukkitMath.getDirection(diffX, diffZ);
            if (direction >= (double)0.01f) {
                direction = Math.sqrt(direction);
                diffX /= direction;
                diffZ /= direction;
                double d3 = Math.min(1.0 / direction, 1.0);
                diffX *= d3;
                diffZ *= d3;
                diffX *= (double)0.05f;
                diffZ *= (double)0.05f;
                diffX *= 1.0 + this.entityCollisionReduction;
                diffZ *= 1.0 + this.entityCollisionReduction;
                if (this.riding == null) {
                    this.motionX -= diffX;
                    this.motionZ -= diffZ;
                }
            }
        }
    }

    @Override
    public boolean canPassThrough() {
        return false;
    }

    @Override
    public void kill() {
        if (!this.isAlive()) {
            return;
        }
        super.kill();
        if (this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS)) {
            Entity damager;
            if (this.lastDamageCause instanceof EntityDamageByEntityEvent && (damager = ((EntityDamageByEntityEvent)this.lastDamageCause).getDamager()) instanceof Player && ((Player)damager).isCreative()) {
                return;
            }
            this.dropItem();
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putInt("Variant", this.woodID);
    }

    public int getVariant() {
        return this.woodID;
    }

    public void setVariant(int variant) {
        this.woodID = variant;
        this.dataProperties.putInt(2, variant);
    }

    public void onInput(double x, double y, double z, double yaw) {
        this.setPositionAndRotation(this.temporalVector.setComponents(x, y - (double)this.getBaseOffset(), z), yaw % 360.0, 0.0);
    }

    public boolean isFull() {
        return this.passengers.size() >= 2;
    }

    @Override
    public String getInteractButtonText() {
        return !this.isFull() ? "action.interact.ride.boat" : "";
    }

    protected void dropItem() {
        this.level.dropItem(this, Item.get(333, (Integer)this.woodID));
    }
}

