/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.item;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.EntityInteractable;
import cn.nukkit.entity.data.StringEntityData;
import cn.nukkit.event.entity.EntityDamageByEntityEvent;
import cn.nukkit.event.entity.EntityDamageEvent;
import cn.nukkit.inventory.EntityArmorInventory;
import cn.nukkit.inventory.EntityEquipmentInventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemArmor;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.particle.DestroyBlockParticle;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import java.util.Collection;

public class EntityArmorStand
extends Entity
implements InventoryHolder,
EntityInteractable {
    public static final int NETWORK_ID = 61;
    public static final String TAG_MAINHAND = "Mainhand";
    public static final String TAG_OFFHAND = "Offhand";
    public static final String TAG_POSE_INDEX = "PoseIndex";
    public static final String TAG_ARMOR = "Armor";
    private EntityEquipmentInventory equipmentInventory;
    private EntityArmorInventory armorInventory;
    private int pose;
    private String nameTag;

    public EntityArmorStand(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
        this.updateMode = 3;
        if (nbt.contains(TAG_POSE_INDEX)) {
            this.setPose(nbt.getInt(TAG_POSE_INDEX));
        }
    }

    private static int getArmorSlot(ItemArmor armorItem) {
        if (armorItem.canBePutInHelmetSlot()) {
            return 0;
        }
        if (armorItem.isChestplate()) {
            return 1;
        }
        if (armorItem.isLeggings()) {
            return 2;
        }
        return 3;
    }

    @Override
    public int getNetworkId() {
        return 61;
    }

    @Override
    protected float getGravity() {
        return 0.04f;
    }

    @Override
    public float getHeight() {
        return 1.975f;
    }

    @Override
    public float getWidth() {
        return 0.5f;
    }

    @Override
    protected void initEntity() {
        this.setMaxHealth(6);
        super.initEntity();
        this.setHealth(6.0f);
        this.setImmobile(true);
        this.equipmentInventory = new EntityEquipmentInventory(this);
        this.armorInventory = new EntityArmorInventory(this);
        if (this.namedTag.contains(TAG_MAINHAND)) {
            this.equipmentInventory.setItemInHand(NBTIO.getItemHelper(this.namedTag.getCompound(TAG_MAINHAND)), true);
        }
        if (this.namedTag.contains(TAG_OFFHAND)) {
            this.equipmentInventory.setOffhandItem(NBTIO.getItemHelper(this.namedTag.getCompound(TAG_OFFHAND)), true);
        }
        if (this.namedTag.contains(TAG_ARMOR)) {
            ListTag<CompoundTag> armorList = this.namedTag.getList(TAG_ARMOR, CompoundTag.class);
            for (CompoundTag armorTag : armorList.getAll()) {
                this.armorInventory.setItem(armorTag.getByte("Slot"), NBTIO.getItemHelper(armorTag));
            }
        }
        if (this.namedTag.contains(TAG_POSE_INDEX)) {
            this.setPose(this.namedTag.getInt(TAG_POSE_INDEX));
        }
    }

    @Override
    public boolean onInteract(Player player, Item item, Vector3 clickedPos) {
        if (!this.isAlive()) {
            return false;
        }
        if (item.getId() == 421 && !player.isAdventure() && item.hasCustomName()) {
            String name = item.getCustomName();
            this.namedTag.putString("CustomName", name);
            this.namedTag.putBoolean("CustomNameVisible", true);
            this.setNameTag(name);
            this.setNameTagVisible(true);
            return true;
        }
        if (player.sneakToBlockInteract()) {
            if (this.getPose() >= 12) {
                this.setPose(0);
            } else {
                this.setPose(this.getPose() + 1);
            }
            this.sendData(this.getViewers().values().toArray(new Player[0]));
            return false;
        }
        if (this.isValid() && !player.isSpectator()) {
            int i = 0;
            boolean flag = !item.isNull();
            boolean isArmorSlot = false;
            if (flag && item instanceof ItemArmor) {
                ItemArmor itemArmor = (ItemArmor)item;
                i = EntityArmorStand.getArmorSlot(itemArmor);
                isArmorSlot = true;
            }
            if (flag && item.getId() == 397 || item.getId() == -155) {
                i = 0;
                isArmorSlot = true;
            }
            int j = 0;
            double d3 = clickedPos.y - this.y;
            boolean flag2 = false;
            if (d3 >= 0.1 && d3 < 0.55 && !this.armorInventory.getItemFast(3).isNull()) {
                j = 3;
                isArmorSlot = true;
                flag2 = true;
            } else if (d3 >= 0.9 && d3 < 1.6 && !this.armorInventory.getItemFast(1).isNull()) {
                j = 1;
                isArmorSlot = true;
                flag2 = true;
            } else if (d3 >= 0.4 && d3 < 1.2 && !this.armorInventory.getItemFast(2).isNull()) {
                j = 2;
                isArmorSlot = true;
                flag2 = true;
            } else if (d3 >= 1.6 && !this.armorInventory.getItemFast(0).isNull()) {
                isArmorSlot = true;
                flag2 = true;
            } else if (!this.equipmentInventory.getItemFast(j).isNull()) {
                flag2 = true;
            }
            if (flag) {
                this.tryChangeEquipment(player, item, i, isArmorSlot);
            } else if (flag2) {
                this.tryChangeEquipment(player, item, j, isArmorSlot);
            }
            return false;
        }
        return false;
    }

    private void tryChangeEquipment(Player player, Item newItem, int slot, boolean isArmorSlot) {
        Item currentItem;
        Item item = currentItem = isArmorSlot ? this.armorInventory.getItem(slot) : this.equipmentInventory.getItem(slot);
        if (currentItem.equals(newItem)) {
            return;
        }
        if (newItem.isNull()) {
            if (isArmorSlot) {
                this.armorInventory.setItem(slot, Item.get(0));
            } else {
                this.equipmentInventory.setItem(slot, Item.get(0));
            }
        } else {
            if (!player.isCreative()) {
                player.getInventory().decreaseCount(player.getInventory().getHeldItemIndex());
            }
            Item itemToAdd = newItem.clone();
            itemToAdd.setCount(1);
            if (isArmorSlot) {
                this.armorInventory.setItem(slot, itemToAdd);
            } else {
                this.equipmentInventory.setItem(slot, itemToAdd);
            }
        }
        if (!currentItem.isNull()) {
            player.getInventory().addItem(currentItem);
        }
        Collection<Player> viewers = this.getViewers().values();
        this.equipmentInventory.sendContents(viewers);
        this.armorInventory.sendContents(viewers);
    }

    public int getPose() {
        return this.pose;
    }

    public void setPose(int pose) {
        this.pose = pose;
        this.dataProperties.putInt(79, pose);
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.put(TAG_MAINHAND, NBTIO.putItemHelper(this.equipmentInventory.getItemInHand()));
        this.namedTag.put(TAG_OFFHAND, NBTIO.putItemHelper(this.equipmentInventory.getOffHandItem()));
        if (this.armorInventory != null) {
            ListTag<CompoundTag> armorTag = new ListTag<CompoundTag>(TAG_ARMOR);
            for (int i = 0; i < 4; ++i) {
                armorTag.add(NBTIO.putItemHelper(this.armorInventory.getItem(i), i));
            }
            this.namedTag.putList(armorTag);
        }
        this.namedTag.putInt(TAG_POSE_INDEX, this.getPose());
    }

    @Override
    public void spawnTo(Player player) {
        super.spawnTo(player);
        this.equipmentInventory.sendContents(player);
        this.armorInventory.sendContents(player);
    }

    @Override
    public boolean attack(EntityDamageEvent source) {
        if (source.getCause() == EntityDamageEvent.DamageCause.CONTACT) {
            source.setCancelled(true);
        }
        if (!this.isAlive() || !super.attack(source)) {
            return false;
        }
        if (!source.isCancelled() && !this.closed) {
            EntityDamageByEntityEvent event;
            this.setGenericFlag(40, true);
            this.level.addParticle(new DestroyBlockParticle(this, Block.get(5)));
            this.kill();
            if (source instanceof EntityDamageByEntityEvent && (event = (EntityDamageByEntityEvent)source).getDamager() instanceof Player) {
                Player player = (Player)event.getDamager();
                if (player.isCreative()) {
                    this.close();
                    return true;
                }
                boolean drop = this.level.getGameRules().getBoolean(GameRule.DO_ENTITY_DROPS);
                if (drop) {
                    this.level.dropItem(this, Item.get(425));
                }
                if (this.equipmentInventory != null) {
                    if (drop) {
                        this.equipmentInventory.getContents().values().forEach(items -> this.level.dropItem(this, (Item)items));
                    }
                    this.equipmentInventory.clearAll();
                }
                if (this.armorInventory != null) {
                    if (drop) {
                        this.armorInventory.getContents().values().forEach(items -> this.level.dropItem(this, (Item)items));
                    }
                    this.armorInventory.clearAll();
                }
            }
        }
        return true;
    }

    @Override
    public String getName() {
        return this.hasCustomName() ? this.getNameTag() : "Armor Stand";
    }

    public EntityEquipmentInventory getEquipmentInventory() {
        return this.equipmentInventory;
    }

    @Override
    public EntityArmorInventory getInventory() {
        return this.armorInventory;
    }

    @Override
    public boolean onUpdate(int currentTick) {
        if (this.closed) {
            return false;
        }
        boolean hasUpdate = super.onUpdate(currentTick);
        if (this.updateMode % 2 == 1) {
            this.updateMode = 3;
            if (this.onGround && this.level.getBlockIdAt(this.chunk, this.getFloorX(), this.getFloorY() - 1, this.getFloorZ()) == 0) {
                this.onGround = false;
            }
        }
        this.motionY = !this.onGround ? (this.motionY -= (double)this.getGravity()) : 0.0;
        this.move(this.motionX, this.motionY, this.motionZ);
        this.motionX *= 0.9;
        this.motionY *= 0.9;
        this.motionZ *= 0.9;
        this.updateMovement();
        return hasUpdate || this.motionX != 0.0 || this.motionY != 0.0 || this.motionZ != 0.0;
    }

    @Override
    public String getInteractButtonText() {
        return "action.interact.armorstand.equip";
    }

    @Override
    public boolean canDoInteraction() {
        return true;
    }

    @Override
    public void setNameTag(String name) {
        this.nameTag = name;
        if (this.namedTag.contains("CustomNameVisible") || this.namedTag.contains("CustomNameAlwaysVisible")) {
            this.setDataProperty(new StringEntityData(4, name));
        }
    }

    @Override
    public boolean hasCustomName() {
        return this.nameTag != null;
    }

    @Override
    public String getNameTag() {
        return this.nameTag == null ? "" : this.nameTag;
    }
}

