/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.data;

import cn.nukkit.Server;
import cn.nukkit.nbt.stream.FastByteArrayOutputStream;
import cn.nukkit.utils.Binary;
import cn.nukkit.utils.PersonaPiece;
import cn.nukkit.utils.PersonaPieceTint;
import cn.nukkit.utils.SerializedImage;
import cn.nukkit.utils.SkinAnimation;
import cn.nukkit.utils.ThreadCache;
import com.google.common.base.Preconditions;
import com.nimbusds.jose.shaded.json.JSONObject;
import com.nimbusds.jose.shaded.json.JSONValue;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;

public class Skin {
    private static final int PIXEL_SIZE = 4;
    public static final int SINGLE_SKIN_SIZE = 8192;
    public static final int DOUBLE_SKIN_SIZE = 16384;
    public static final int SKIN_128_64_SIZE = 32768;
    public static final int SKIN_128_128_SIZE = 65536;
    private static final int MAX_DATA_SIZE = 262144;
    public static final String GEOMETRY_CUSTOM = Skin.convertLegacyGeometryName("geometry.humanoid.custom");
    public static final String GEOMETRY_CUSTOM_SLIM = Skin.convertLegacyGeometryName("geometry.humanoid.customSlim");
    private boolean noPlayFab;
    private String fullSkinId;
    private String skinId;
    private String playFabId = "";
    private String skinResourcePatch = GEOMETRY_CUSTOM;
    private SerializedImage skinData;
    private final List<SkinAnimation> animations = new ArrayList<SkinAnimation>();
    private final List<PersonaPiece> personaPieces = new ArrayList<PersonaPiece>();
    private final List<PersonaPieceTint> tintColors = new ArrayList<PersonaPieceTint>();
    private SerializedImage capeData;
    private String geometryData;
    private String animationData;
    private boolean premium;
    private boolean persona;
    private boolean capeOnClassic;
    private boolean primaryUser = true;
    private String capeId;
    private String skinColor = "#0";
    private String armSize = "wide";
    private boolean trusted = true;
    private String geometryDataEngineVersion = "";
    private boolean overridingPlayerAppearance = true;

    public boolean isValid() {
        return this.isValidSkin() && this.isValidResourcePatch();
    }

    private boolean isValidSkin() {
        try {
            return !(this.skinId == null || this.skinId.trim().isEmpty() || this.skinId.length() >= 100 || this.skinData == null || this.skinData.width < 64 || this.skinData.height < 32 || this.skinData.data.length < 8192 || this.geometryData == null || this.geometryData.isEmpty() || this.geometryData.getBytes().length > 262144 || this.skinData.data.length > 262144 || this.capeData != null && this.capeData.data.length > 262144 || this.animationData != null && this.animationData.getBytes().length > 262144 || this.playFabId != null && this.playFabId.length() >= 100 || this.capeId != null && this.capeId.length() >= 100 || this.skinColor != null && this.skinColor.length() >= 100 || this.armSize != null && this.armSize.length() >= 100 || this.fullSkinId != null && this.fullSkinId.length() >= 200 || this.geometryDataEngineVersion != null && this.geometryDataEngineVersion.length() >= 100);
        }
        catch (Exception ex) {
            Server.getInstance().getLogger().logException(ex);
            return false;
        }
    }

    private boolean isValidResourcePatch() {
        if (this.skinResourcePatch == null || this.skinResourcePatch.length() > 1000) {
            return false;
        }
        try {
            JSONObject geometry = (JSONObject)((JSONObject)JSONValue.parse(this.skinResourcePatch)).get("geometry");
            return geometry.containsKey("default") && geometry.get("default") instanceof String;
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    public SerializedImage getSkinData() {
        if (this.skinData == null) {
            return SerializedImage.EMPTY;
        }
        return this.skinData;
    }

    public String getSkinId() {
        if (this.skinId == null) {
            Server.getInstance().getLogger().debug("Missing skin ID, generating new");
            this.generateSkinId("Custom");
        }
        return this.skinId;
    }

    public void setSkinId(String skinId) {
        if (skinId == null || skinId.trim().isEmpty()) {
            Server.getInstance().getLogger().debug("Skin ID cannot be empty! ", new Throwable(""));
            return;
        }
        this.skinId = skinId;
    }

    public void generateSkinId(String name) {
        byte[] data = Binary.appendBytes(this.getSkinData().data, (byte[][])new byte[][]{this.getSkinResourcePatch().getBytes(StandardCharsets.UTF_8)});
        this.skinId = UUID.nameUUIDFromBytes(data) + "." + name;
    }

    public void setSkinData(byte[] skinData) {
        this.setSkinData(SerializedImage.fromLegacy(skinData));
    }

    public void setSkinData(BufferedImage image) {
        this.setSkinData(Skin.parseBufferedImage(image));
    }

    public void setSkinData(SerializedImage skinData) {
        Objects.requireNonNull(skinData, "skinData");
        this.skinData = skinData;
    }

    public void setSkinResourcePatch(String skinResourcePatch) {
        if (skinResourcePatch == null || skinResourcePatch.trim().isEmpty()) {
            this.skinResourcePatch = GEOMETRY_CUSTOM;
            return;
        }
        this.skinResourcePatch = skinResourcePatch;
    }

    public void setGeometryName(String geometryName) {
        if (geometryName.trim().isEmpty()) {
            this.skinResourcePatch = GEOMETRY_CUSTOM;
            return;
        }
        this.skinResourcePatch = "{\"geometry\" : {\"default\" : \"" + geometryName + "\"}}";
    }

    public String getSkinResourcePatch() {
        if (this.skinResourcePatch == null) {
            return "";
        }
        return this.skinResourcePatch;
    }

    public SerializedImage getCapeData() {
        if (this.capeData == null) {
            return SerializedImage.EMPTY;
        }
        return this.capeData;
    }

    public String getCapeId() {
        if (this.capeId == null) {
            return "";
        }
        return this.capeId;
    }

    public void setCapeId(String capeId) {
        if (capeId == null || capeId.trim().isEmpty()) {
            capeId = null;
        }
        this.capeId = capeId;
    }

    public void setCapeData(byte[] capeData) {
        Objects.requireNonNull(capeData, "capeData");
        if (capeData.length == 8192) {
            this.setCapeData(new SerializedImage(64, 32, capeData));
        }
    }

    public void setCapeData(BufferedImage image) {
        this.setCapeData(Skin.parseBufferedImage(image));
    }

    public void setCapeData(SerializedImage capeData) {
        Objects.requireNonNull(capeData, "capeData");
        this.capeData = capeData;
    }

    public String getGeometryData() {
        if (this.geometryData == null) {
            return "";
        }
        return this.geometryData;
    }

    public void setGeometryData(String geometryData) {
        Preconditions.checkNotNull(geometryData, "geometryData");
        if (!geometryData.equals(this.geometryData)) {
            this.geometryData = geometryData;
        }
    }

    public String getAnimationData() {
        if (this.animationData == null) {
            return "";
        }
        return this.animationData;
    }

    public void setAnimationData(String animationData) {
        Preconditions.checkNotNull(animationData, "animationData");
        if (!animationData.equals(this.animationData)) {
            this.animationData = animationData;
        }
    }

    public List<SkinAnimation> getAnimations() {
        return this.animations;
    }

    public List<PersonaPiece> getPersonaPieces() {
        return this.personaPieces;
    }

    public List<PersonaPieceTint> getTintColors() {
        return this.tintColors;
    }

    public boolean isPremium() {
        return this.premium;
    }

    public void setPremium(boolean premium) {
        this.premium = premium;
    }

    public boolean isPersona() {
        return this.persona;
    }

    public void setPersona(boolean persona) {
        this.persona = persona;
    }

    public boolean isCapeOnClassic() {
        return this.capeOnClassic;
    }

    public void setCapeOnClassic(boolean capeOnClassic) {
        this.capeOnClassic = capeOnClassic;
    }

    public void setPrimaryUser(boolean primaryUser) {
        this.primaryUser = primaryUser;
    }

    public boolean isPrimaryUser() {
        return this.primaryUser;
    }

    public void setGeometryDataEngineVersion(String geometryDataEngineVersion) {
        this.geometryDataEngineVersion = geometryDataEngineVersion;
    }

    public String getGeometryDataEngineVersion() {
        return this.geometryDataEngineVersion;
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    public String getSkinColor() {
        return this.skinColor;
    }

    public void setSkinColor(String skinColor) {
        this.skinColor = skinColor;
    }

    public String getArmSize() {
        return this.armSize;
    }

    public void setArmSize(String armSize) {
        this.armSize = armSize;
    }

    public void setFullSkinId(String fullSkinId) {
        this.fullSkinId = fullSkinId;
        this.noPlayFab = false;
    }

    public String getFullSkinId() {
        if (this.fullSkinId == null) {
            this.fullSkinId = this.getSkinId() + this.getCapeId();
            this.noPlayFab = false;
        }
        return this.fullSkinId;
    }

    public void setPlayFabId(String playFabId) {
        this.playFabId = playFabId;
        this.noPlayFab = false;
    }

    public String getPlayFabId() {
        if (this.noPlayFab) {
            return "";
        }
        if (this.playFabId == null || this.playFabId.isEmpty()) {
            String[] split = this.getFullSkinId().split("-", 6);
            if (split.length > 5) {
                this.playFabId = split[5];
                this.noPlayFab = false;
            } else {
                try {
                    this.playFabId = this.getFullSkinId().replace("-", "").substring(16);
                    this.noPlayFab = false;
                }
                catch (Exception ignore) {
                    Server.getInstance().getLogger().debug("Couldn't generate Skin playFabId for " + this.getFullSkinId());
                    this.playFabId = "";
                    this.noPlayFab = true;
                }
            }
        }
        return this.playFabId;
    }

    private static SerializedImage parseBufferedImage(BufferedImage image) {
        FastByteArrayOutputStream outputStream = ThreadCache.fbaos.get().reset();
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                Color color = new Color(image.getRGB(x, y), true);
                outputStream.write(color.getRed());
                outputStream.write(color.getGreen());
                outputStream.write(color.getBlue());
                outputStream.write(color.getAlpha());
            }
        }
        image.flush();
        return new SerializedImage(image.getWidth(), image.getHeight(), outputStream.toByteArray());
    }

    private static String convertLegacyGeometryName(String geometryName) {
        return "{\"geometry\" : {\"default\" : \"" + geometryName + "\"}}";
    }

    public void setOverridingPlayerAppearance(boolean overridingPlayerAppearance) {
        this.overridingPlayerAppearance = overridingPlayerAppearance;
    }

    public boolean isOverridingPlayerAppearance() {
        return this.overridingPlayerAppearance;
    }

    @Generated
    public String toString() {
        return "Skin(noPlayFab=" + this.noPlayFab + ", fullSkinId=" + this.getFullSkinId() + ", skinId=" + this.getSkinId() + ", playFabId=" + this.getPlayFabId() + ", skinResourcePatch=" + this.getSkinResourcePatch() + ", skinData=" + this.getSkinData() + ", animations=" + this.getAnimations() + ", personaPieces=" + this.getPersonaPieces() + ", tintColors=" + this.getTintColors() + ", capeData=" + this.getCapeData() + ", geometryData=" + this.getGeometryData() + ", animationData=" + this.getAnimationData() + ", premium=" + this.isPremium() + ", persona=" + this.isPersona() + ", capeOnClassic=" + this.isCapeOnClassic() + ", primaryUser=" + this.isPrimaryUser() + ", capeId=" + this.getCapeId() + ", skinColor=" + this.getSkinColor() + ", armSize=" + this.getArmSize() + ", trusted=" + this.isTrusted() + ", geometryDataEngineVersion=" + this.getGeometryDataEngineVersion() + ", overridingPlayerAppearance=" + this.isOverridingPlayerAppearance() + ")";
    }
}

