/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.entity.custom;

import cn.nukkit.entity.Entity;
import cn.nukkit.entity.custom.CustomEntity;
import cn.nukkit.entity.custom.EntityManager;
import cn.nukkit.nbt.tag.CompoundTag;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public class EntityDefinition {
    public static final AtomicInteger ID_ALLOCATOR = new AtomicInteger(10000);
    private final String identifier;
    private final String parentEntity;
    private final boolean spawnEgg;
    private final String alternateName;
    private final Class<? extends Entity> implementation;
    private final boolean serverSideOnly;
    private final int runtimeId;
    private CompoundTag networkTag;

    public EntityDefinition(String identifier, String parentEntity, boolean spawnEgg, String alternateName, Class<? extends Entity> implementation, boolean serverSideOnly) {
        if (!CustomEntity.class.isAssignableFrom(implementation)) {
            throw new IllegalArgumentException("Implementation class must implement CustomEntity interface");
        }
        if (serverSideOnly && parentEntity == null) {
            throw new IllegalArgumentException("Server side entity must have parent entity set");
        }
        this.identifier = identifier;
        this.parentEntity = parentEntity;
        this.spawnEgg = spawnEgg;
        this.alternateName = alternateName;
        this.implementation = implementation;
        this.serverSideOnly = serverSideOnly;
        if (this.serverSideOnly) {
            int runtimeId = EntityManager.get().getRuntimeId(this.parentEntity);
            if (runtimeId == 0) {
                throw new IllegalArgumentException("Unknown entity type " + this.parentEntity);
            }
            this.runtimeId = runtimeId;
        } else {
            this.runtimeId = ID_ALLOCATOR.getAndIncrement();
        }
    }

    private CompoundTag createNetworkTag() {
        CompoundTag nbt = new CompoundTag("");
        nbt.putBoolean("hasspawnegg", this.spawnEgg);
        nbt.putBoolean("summonable", true);
        nbt.putString("id", this.identifier);
        nbt.putString("bid", this.parentEntity == null ? "" : this.parentEntity);
        nbt.putInt("rid", this.runtimeId);
        return nbt;
    }

    public CompoundTag getNetworkTag() {
        if (this.networkTag == null) {
            this.networkTag = this.createNetworkTag();
        }
        return this.networkTag;
    }

    @Generated
    public static EntityDefinitionBuilder builder() {
        return new EntityDefinitionBuilder();
    }

    @Generated
    public String getIdentifier() {
        return this.identifier;
    }

    @Generated
    public String getParentEntity() {
        return this.parentEntity;
    }

    @Generated
    public boolean isSpawnEgg() {
        return this.spawnEgg;
    }

    @Generated
    public String getAlternateName() {
        return this.alternateName;
    }

    @Generated
    public Class<? extends Entity> getImplementation() {
        return this.implementation;
    }

    @Generated
    public boolean isServerSideOnly() {
        return this.serverSideOnly;
    }

    @Generated
    public int getRuntimeId() {
        return this.runtimeId;
    }

    @Generated
    public static class EntityDefinitionBuilder {
        @Generated
        private String identifier;
        @Generated
        private String parentEntity;
        @Generated
        private boolean spawnEgg;
        @Generated
        private String alternateName;
        @Generated
        private Class<? extends Entity> implementation;
        @Generated
        private boolean serverSideOnly;

        @Generated
        EntityDefinitionBuilder() {
        }

        @Generated
        public EntityDefinitionBuilder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Generated
        public EntityDefinitionBuilder parentEntity(String parentEntity) {
            this.parentEntity = parentEntity;
            return this;
        }

        @Generated
        public EntityDefinitionBuilder spawnEgg(boolean spawnEgg) {
            this.spawnEgg = spawnEgg;
            return this;
        }

        @Generated
        public EntityDefinitionBuilder alternateName(String alternateName) {
            this.alternateName = alternateName;
            return this;
        }

        @Generated
        public EntityDefinitionBuilder implementation(Class<? extends Entity> implementation) {
            this.implementation = implementation;
            return this;
        }

        @Generated
        public EntityDefinitionBuilder serverSideOnly(boolean serverSideOnly) {
            this.serverSideOnly = serverSideOnly;
            return this;
        }

        @Generated
        public EntityDefinition build() {
            return new EntityDefinition(this.identifier, this.parentEntity, this.spawnEgg, this.alternateName, this.implementation, this.serverSideOnly);
        }

        @Generated
        public String toString() {
            return "EntityDefinition.EntityDefinitionBuilder(identifier=" + this.identifier + ", parentEntity=" + this.parentEntity + ", spawnEgg=" + this.spawnEgg + ", alternateName=" + this.alternateName + ", implementation=" + this.implementation + ", serverSideOnly=" + this.serverSideOnly + ")";
        }
    }
}

