/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.dispenser;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDispenser;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.dispenser.DefaultDispenseBehavior;
import cn.nukkit.item.Item;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;

public class ShulkerBoxDispenseBehavior
extends DefaultDispenseBehavior {
    @Override
    public Item dispense(BlockDispenser block, BlockFace face, Item item) {
        Block target = block.getSide(face);
        if (target.getId() == 0) {
            CompoundTag tag;
            CompoundTag nbt = BlockEntity.getDefaultCompound(target, "ShulkerBox");
            nbt.putByte("facing", BlockFace.UP.getIndex());
            if (item.hasCustomName()) {
                nbt.putString("CustomName", item.getCustomName());
            }
            if ((tag = item.getNamedTag()) != null && tag.contains("Items")) {
                nbt.putList(tag.getList("Items"));
            }
            block.level.setBlock(target, Block.get(218, item.getDamage()), true);
            BlockEntity.createBlockEntity("ShulkerBox", block.level.getChunk(target.getChunkX(), target.getChunkZ()), nbt, new Object[0]);
            return null;
        }
        return item;
    }
}

