/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.dispenser;

import cn.nukkit.block.BlockDispenser;
import cn.nukkit.dispenser.DefaultDispenseBehavior;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.projectile.EntityProjectile;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.tag.CompoundTag;

public class ProjectileDispenseBehavior
extends DefaultDispenseBehavior {
    private final String entityType;

    public ProjectileDispenseBehavior(String entity) {
        this.entityType = entity;
    }

    @Override
    public Item dispense(BlockDispenser source, BlockFace face, Item item) {
        Vector3 dispensePos = source.getDispensePosition();
        CompoundTag nbt = Entity.getDefaultNBT(dispensePos);
        this.correctNBT(nbt, item);
        Entity projectile = Entity.createEntity(this.entityType, (FullChunk)source.level.getChunk(dispensePos.getChunkX(), dispensePos.getChunkZ()), nbt, new Object[0]);
        if (!(projectile instanceof EntityProjectile)) {
            return super.dispense(source, face, item);
        }
        Vector3 motion = new Vector3(face.getXOffset(), (float)face.getYOffset() + 0.1f, face.getZOffset()).normalize();
        projectile.setMotion(motion);
        ((EntityProjectile)projectile).inaccurate(this.getAccuracy());
        projectile.setMotion(projectile.getMotion().multiply(this.getMotion()));
        ((EntityProjectile)projectile).updateRotation();
        projectile.spawnToAll();
        return null;
    }

    protected double getMotion() {
        return 1.1;
    }

    protected float getAccuracy() {
        return 6.0f;
    }

    protected void correctNBT(CompoundTag nbt, Item item) {
        if (item != null) {
            if (item.getId() == 438 || item.getId() == 441) {
                nbt.putInt("PotionId", item.getDamage());
            } else if (item.getId() == 262 && item.getDamage() > 0) {
                nbt.putByte("arrowData", item.getDamage());
            }
        }
    }
}

