/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.dispenser;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDispenser;
import cn.nukkit.block.BlockRail;
import cn.nukkit.dispenser.DefaultDispenseBehavior;
import cn.nukkit.entity.Entity;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockFace;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.DoubleTag;
import cn.nukkit.nbt.tag.FloatTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.utils.Rail;

public class MinecartDispenseBehavior
extends DefaultDispenseBehavior {
    @Override
    public Item dispense(BlockDispenser block, BlockFace face, Item item) {
        Block target = block.getSide(face);
        if (Rail.isRailBlock(target)) {
            Rail.Orientation type = ((BlockRail)target).getOrientation();
            double adjacent = 0.0;
            if (type.isAscending()) {
                adjacent = 0.5;
            }
            Entity minecart = Entity.createEntity(this.getMinecartId(item), (FullChunk)block.level.getChunk(target.getChunkX(), target.getChunkZ()), new CompoundTag("").putList(new ListTag<DoubleTag>("Pos").add(new DoubleTag("", target.getX() + 0.5)).add(new DoubleTag("", target.getY() + 0.0625 + adjacent)).add(new DoubleTag("", target.getZ() + 0.5))).putList(new ListTag<DoubleTag>("Motion").add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0)).add(new DoubleTag("", 0.0))).putList(new ListTag<FloatTag>("Rotation").add(new FloatTag("", 0.0f)).add(new FloatTag("", 0.0f))), new Object[0]);
            minecart.spawnToAll();
            return null;
        }
        return super.dispense(block, face, item);
    }

    private String getMinecartId(Item item) {
        switch (item.getId()) {
            case 342: {
                return "MinecartChest";
            }
            case 408: {
                return "MinecartHopper";
            }
            case 407: {
                return "MinecartTnt";
            }
        }
        return "MinecartRideable";
    }
}

