/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.dispenser;

import cn.nukkit.dispenser.BoatDispenseBehavior;
import cn.nukkit.dispenser.BucketDispenseBehavior;
import cn.nukkit.dispenser.ChestBoatDispenseBehavior;
import cn.nukkit.dispenser.DefaultDispenseBehavior;
import cn.nukkit.dispenser.DispenseBehavior;
import cn.nukkit.dispenser.DyeDispenseBehavior;
import cn.nukkit.dispenser.FireChargeDispenseBehavior;
import cn.nukkit.dispenser.FireworksDispenseBehavior;
import cn.nukkit.dispenser.FlintAndSteelDispenseBehavior;
import cn.nukkit.dispenser.MinecartDispenseBehavior;
import cn.nukkit.dispenser.ProjectileDispenseBehavior;
import cn.nukkit.dispenser.ShearsDispenseBehaviour;
import cn.nukkit.dispenser.ShulkerBoxDispenseBehavior;
import cn.nukkit.dispenser.SpawnEggDispenseBehavior;
import cn.nukkit.dispenser.TNTDispenseBehavior;
import cn.nukkit.dispenser.UndyedShulkerBoxDispenseBehavior;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public final class DispenseBehaviorRegister {
    private static final Int2ObjectMap<DispenseBehavior> behaviors = new Int2ObjectOpenHashMap<DispenseBehavior>();
    private static final DispenseBehavior defaultBehavior = new DefaultDispenseBehavior();

    public static void registerBehavior(int itemId, DispenseBehavior behavior) {
        behaviors.put(itemId, behavior);
    }

    public static DispenseBehavior getBehavior(int id) {
        return behaviors.getOrDefault(id, defaultBehavior);
    }

    public static void removeDispenseBehavior(int id) {
        behaviors.remove(id);
    }

    public static void init() {
        DispenseBehaviorRegister.registerBehavior(333, new BoatDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(325, new BucketDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(351, new DyeDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(401, new FireworksDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(259, new FlintAndSteelDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(218, new ShulkerBoxDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(205, new UndyedShulkerBoxDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(383, new SpawnEggDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(46, new TNTDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(385, new FireChargeDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(359, new ShearsDispenseBehaviour());
        DispenseBehaviorRegister.registerBehavior(262, new ProjectileDispenseBehavior("Arrow"){

            @Override
            protected double getMotion() {
                return super.getMotion() * 1.5;
            }
        });
        DispenseBehaviorRegister.registerBehavior(344, new ProjectileDispenseBehavior("Egg"));
        DispenseBehaviorRegister.registerBehavior(332, new ProjectileDispenseBehavior("Snowball"));
        DispenseBehaviorRegister.registerBehavior(384, new ProjectileDispenseBehavior("ThrownExpBottle"){

            @Override
            protected float getAccuracy() {
                return super.getAccuracy() * 0.5f;
            }

            @Override
            protected double getMotion() {
                return super.getMotion() * 1.25;
            }
        });
        DispenseBehaviorRegister.registerBehavior(438, new ProjectileDispenseBehavior("ThrownPotion"){

            @Override
            protected float getAccuracy() {
                return super.getAccuracy() * 0.5f;
            }

            @Override
            protected double getMotion() {
                return super.getMotion() * 1.25;
            }
        });
        DispenseBehaviorRegister.registerBehavior(441, new ProjectileDispenseBehavior("LingeringPotion"){

            @Override
            protected float getAccuracy() {
                return super.getAccuracy() * 0.5f;
            }

            @Override
            protected double getMotion() {
                return super.getMotion() * 1.25;
            }
        });
        DispenseBehaviorRegister.registerBehavior(455, new ProjectileDispenseBehavior("ThrownTrident"){

            @Override
            protected float getAccuracy() {
                return super.getAccuracy() * 0.5f;
            }

            @Override
            protected double getMotion() {
                return super.getMotion() * 1.25;
            }
        });
        DispenseBehaviorRegister.registerBehavior(642, new ChestBoatDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(643, new ChestBoatDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(639, new ChestBoatDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(640, new ChestBoatDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(644, new ChestBoatDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(641, new ChestBoatDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(638, new ChestBoatDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(328, new MinecartDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(342, new MinecartDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(408, new MinecartDispenseBehavior());
        DispenseBehaviorRegister.registerBehavior(407, new MinecartDispenseBehavior());
    }
}

