/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.dispenser;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDispenser;
import cn.nukkit.block.BlockWater;
import cn.nukkit.dispenser.DefaultDispenseBehavior;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityChestBoat;
import cn.nukkit.item.Item;
import cn.nukkit.level.Location;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.BlockFace;

public class ChestBoatDispenseBehavior
extends DefaultDispenseBehavior {
    @Override
    public Item dispense(BlockDispenser block, BlockFace face, Item item) {
        Block target = block.getSide(face);
        if (!(target instanceof BlockWater || target.getId() == 0 && target.down() instanceof BlockWater)) {
            return super.dispense(block, face, item);
        }
        Location pos = target.getLocation().setYaw(face.getHorizontalAngle());
        EntityChestBoat boat = (EntityChestBoat)Entity.createEntity(218, (FullChunk)block.level.getChunk(pos.getChunkX(), pos.getChunkZ()), Entity.getDefaultNBT(pos).putByte("Variant", ChestBoatDispenseBehavior.getBoatId(item)), new Object[0]);
        boat.spawnToAll();
        return null;
    }

    private static int getBoatId(Item item) {
        switch (item.getId()) {
            case 641: {
                return 1;
            }
            case 639: {
                return 2;
            }
            case 640: {
                return 3;
            }
            case 642: {
                return 4;
            }
            case 643: {
                return 5;
            }
            case 644: {
                return 6;
            }
        }
        return 0;
    }
}

