/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.dispenser;

import cn.nukkit.block.Block;
import cn.nukkit.block.BlockDispenser;
import cn.nukkit.block.BlockLiquid;
import cn.nukkit.dispenser.DefaultDispenseBehavior;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBucket;
import cn.nukkit.level.particle.SmokeParticle;
import cn.nukkit.math.BlockFace;

public class BucketDispenseBehavior
extends DefaultDispenseBehavior {
    @Override
    public Item dispense(BlockDispenser block, BlockFace face, Item item) {
        Block target = block.getSide(face);
        if (item.getDamage() > 0) {
            Block replace;
            if (target.canBeFlowedInto() && (replace = Block.get(ItemBucket.getBlockByDamage(item.getDamage()))) instanceof BlockLiquid) {
                if (block.level.getDimension() == 1) {
                    replace = Block.get(0);
                    block.level.addParticle(new SmokeParticle(target.add(0.5, 0.5, 0.5)), null, 4);
                }
                block.level.setBlock(target, replace);
                return Item.get(325);
            }
        } else if (target instanceof BlockLiquid && target.getDamage() == 0) {
            target.level.setBlock(target, Block.get(0));
            return Item.get(325, (Integer)ItemBucket.getDamageByTarget(target.getId()));
        }
        return super.dispense(block, face, item);
    }
}

