/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.Player;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.data.CommandParamType;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.utils.TextFormat;
import java.util.Objects;

public class TellCommand
extends VanillaCommand {
    public TellCommand(String name) {
        super(name, "%nukkit.command.tell.description", "%commands.message.usage", new String[]{"w", "msg"});
        this.setPermission("nukkit.command.tell");
        this.commandParameters.clear();
        this.commandParameters.put("default", new CommandParameter[]{CommandParameter.newType("player", CommandParamType.TARGET), CommandParameter.newType("message", CommandParamType.MESSAGE)});
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return false;
        }
        String name = args[0].replace("@s", sender.getName());
        Player player = sender.getServer().getPlayerExact(name);
        if (player == null) {
            sender.sendMessage(new TranslationContainer("commands.generic.player.notFound"));
            return true;
        }
        if (Objects.equals(player, sender)) {
            sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.message.sameTarget"));
            return true;
        }
        StringBuilder msg = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            msg.append(args[i]).append(' ');
        }
        if (msg.length() > 512) {
            sender.sendMessage((Object)((Object)TextFormat.RED) + "The message is too long");
            return true;
        }
        if (msg.length() > 0) {
            msg = new StringBuilder(msg.substring(0, msg.length() - 1));
        }
        String displayName = sender instanceof Player ? ((Player)sender).getDisplayName() : sender.getName();
        sender.sendMessage('[' + sender.getName() + " -> " + player.getDisplayName() + "] " + msg);
        player.sendMessage('[' + displayName + " -> " + player.getName() + "] " + msg);
        if (sender instanceof Player) {
            sender.getServer().getLogger().info('[' + sender.getName() + " -> " + player.getDisplayName() + "] " + msg);
        }
        return true;
    }
}

