/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.ConsoleCommandSender;
import cn.nukkit.command.data.CommandParamType;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.utils.TextFormat;
import java.util.TreeMap;

public class HelpCommand
extends VanillaCommand {
    public HelpCommand(String name) {
        super(name, "%nukkit.command.help.description", "%commands.help.usage", new String[]{"?"});
        this.setPermission("nukkit.command.help");
        this.commandParameters.clear();
        this.commandParameters.put("default", new CommandParameter[]{CommandParameter.newType("page", true, CommandParamType.INT)});
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        StringBuilder command = new StringBuilder();
        int pageNumber = 1;
        int pageHeight = 5;
        if (args.length != 0) {
            try {
                pageNumber = Integer.parseInt(args[args.length - 1]);
                if (pageNumber <= 0) {
                    pageNumber = 1;
                }
                String[] newargs = new String[args.length - 1];
                System.arraycopy(args, 0, newargs, 0, newargs.length);
                args = newargs;
                for (String string : args) {
                    if (command.length() > 0) {
                        command.append(' ');
                    }
                    command.append(string);
                }
            }
            catch (NumberFormatException e) {
                pageNumber = 1;
                for (String string : args) {
                    if (command.length() > 0) {
                        command.append(' ');
                    }
                    command.append(string);
                }
            }
        }
        if (sender instanceof ConsoleCommandSender) {
            pageHeight = Integer.MAX_VALUE;
        }
        if (command.length() == 0) {
            TreeMap<String, Command> commands = new TreeMap<String, Command>();
            for (Command cmd : sender.getServer().getCommandMap().getCommands().values()) {
                if (!cmd.testPermissionSilent(sender)) continue;
                commands.put(cmd.getName(), cmd);
            }
            int totalPage = commands.size() % pageHeight == 0 ? commands.size() / pageHeight : commands.size() / pageHeight + 1;
            if ((pageNumber = Math.min(pageNumber, totalPage)) < 1) {
                pageNumber = 1;
            }
            sender.sendMessage(new TranslationContainer("commands.help.header", String.valueOf(pageNumber), String.valueOf(totalPage)));
            int i = 1;
            for (Command command2 : commands.values()) {
                if (i >= (pageNumber - 1) * pageHeight + 1 && i <= Math.min(commands.size(), pageNumber * pageHeight)) {
                    sender.sendMessage((Object)((Object)TextFormat.DARK_GREEN) + "/" + command2.getName() + ": " + (Object)((Object)TextFormat.WHITE) + command2.getDescription());
                }
                ++i;
            }
            return true;
        }
        Command cmd = sender.getServer().getCommandMap().getCommand(command.toString().toLowerCase());
        if (cmd != null && cmd.testPermissionSilent(sender)) {
            String[] usages;
            String message = (Object)((Object)TextFormat.YELLOW) + "--------- " + (Object)((Object)TextFormat.WHITE) + " Help: /" + cmd.getName() + (Object)((Object)TextFormat.YELLOW) + " ---------\n";
            message = message + (Object)((Object)TextFormat.GOLD) + "Description: " + (Object)((Object)TextFormat.WHITE) + cmd.getDescription() + '\n';
            StringBuilder usage = new StringBuilder();
            for (String u : usages = cmd.getUsage().split("\n")) {
                if (usage.length() > 0) {
                    usage.append("\n" + (Object)((Object)TextFormat.WHITE));
                }
                usage.append(u);
            }
            message = message + (Object)((Object)TextFormat.GOLD) + "Usage: " + (Object)((Object)TextFormat.WHITE) + usage + '\n';
            sender.sendMessage(message);
            return true;
        }
        sender.sendMessage((Object)((Object)TextFormat.RED) + "No help for " + command.toString().toLowerCase());
        return true;
    }
}

