/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.defaults;

import cn.nukkit.Server;
import cn.nukkit.command.Command;
import cn.nukkit.command.CommandSender;
import cn.nukkit.command.data.CommandEnum;
import cn.nukkit.command.data.CommandParamType;
import cn.nukkit.command.data.CommandParameter;
import cn.nukkit.command.defaults.VanillaCommand;
import cn.nukkit.lang.TranslationContainer;
import cn.nukkit.network.protocol.DataPacket;
import cn.nukkit.network.protocol.SetDefaultGameTypePacket;
import cn.nukkit.utils.TextFormat;

public class DefaultGamemodeCommand
extends VanillaCommand {
    public DefaultGamemodeCommand(String name) {
        super(name, "%nukkit.command.defaultgamemode.description", "%commands.defaultgamemode.usage");
        this.setPermission("nukkit.command.defaultgamemode");
        this.commandParameters.clear();
        this.commandParameters.put("default", new CommandParameter[]{CommandParameter.newType("gameMode", CommandParamType.INT)});
        this.commandParameters.put("byString", new CommandParameter[]{CommandParameter.newEnum("gameMode", CommandEnum.ENUM_GAMEMODE)});
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(new TranslationContainer("commands.generic.usage", this.usageMessage));
            return false;
        }
        int gameMode = Server.getGamemodeFromString(args[0]);
        if (gameMode != -1) {
            sender.getServer().setPropertyInt("gamemode", gameMode);
            sender.getServer().gamemode = gameMode;
            sender.sendMessage(new TranslationContainer("commands.defaultgamemode.success", new String[]{Server.getGamemodeString(gameMode)}));
            Command.broadcastCommandMessage(sender, new TranslationContainer("commands.defaultgamemode.success", new String[]{Server.getGamemodeString(sender.getServer().getDefaultGamemode())}));
            SetDefaultGameTypePacket gameTypePacket = new SetDefaultGameTypePacket();
            gameTypePacket.gamemode = sender.getServer().getDefaultGamemode();
            Server.broadcastPacket(sender.getServer().getOnlinePlayers().values(), (DataPacket)gameTypePacket);
        } else {
            sender.sendMessage(new TranslationContainer((Object)((Object)TextFormat.RED) + "%commands.gamemode.fail.invalid", args[0]));
        }
        return true;
    }
}

