/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.command.data;

import cn.nukkit.block.BlockID;
import cn.nukkit.item.ItemID;
import cn.nukkit.potion.Effect;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public class CommandEnum {
    public static final CommandEnum ENUM_BOOLEAN = new CommandEnum("Boolean", ImmutableList.of("true", "false"));
    public static final CommandEnum ENUM_GAMEMODE = new CommandEnum("GameMode", ImmutableList.of("default", "creative", "spectator", "survival", "adventure", "d", "c", "s", "a"));
    public static final CommandEnum ENUM_DIFFICULTY = new CommandEnum("Difficulty", ImmutableList.of("peaceful", "p", "easy", "e", "normal", "n", "hard", "h"));
    public static final CommandEnum ENUM_BLOCK;
    public static final CommandEnum ENUM_ITEM;
    public static final CommandEnum ENUM_EFFECTS;
    private final String name;
    private final List<String> values;

    public CommandEnum(String name, String ... values) {
        this(name, Arrays.asList(values));
    }

    public CommandEnum(String name, List<String> values) {
        this.name = name;
        this.values = values;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getValues() {
        return this.values;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    static {
        ImmutableList.Builder blocks = ImmutableList.builder();
        for (Field field : BlockID.class.getDeclaredFields()) {
            blocks.add(field.getName().toLowerCase());
        }
        ENUM_BLOCK = new CommandEnum("Block", (List<String>)((Object)blocks.build()));
        ImmutableList.Builder items = ImmutableList.builder();
        for (Field field : ItemID.class.getDeclaredFields()) {
            items.add(field.getName().toLowerCase());
        }
        items.addAll(ENUM_BLOCK.getValues());
        ENUM_ITEM = new CommandEnum("Item", (List<String>)((Object)items.build()));
        ImmutableList.Builder effects = ImmutableList.builder();
        for (Field field : Effect.class.getDeclaredFields()) {
            if (field.getType() != Integer.TYPE || field.getModifiers() != 25) continue;
            effects.add(field.getName().toLowerCase());
        }
        ENUM_EFFECTS = new CommandEnum("Effect", (List<String>)((Object)effects.build()));
    }
}

