/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.level.persistence.PersistentDataContainer;
import cn.nukkit.nbt.tag.CompoundTag;
import lombok.Generated;

public class PersistentDataContainerBlockEntity
extends BlockEntity
implements PersistentDataContainer {
    public PersistentDataContainerBlockEntity(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public boolean onUpdate() {
        if (!this.isBlockEntityValid()) {
            this.close();
        }
        return false;
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.level.getBlockIdAt(this.chunk, (int)this.x, (int)this.y, (int)this.z) != 0;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isBlockEntityValid();
    }

    @Override
    public CompoundTag getStorage() {
        if (this.namedTag.contains("persistent_storage")) {
            return this.namedTag.getCompound("persistent_storage");
        }
        CompoundTag storage = new CompoundTag();
        this.setStorage(storage);
        return storage;
    }

    @Override
    public void setStorage(CompoundTag storage) {
        this.namedTag.put("persistent_storage", storage);
        this.setDirty();
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PersistentDataContainerBlockEntity && super.equals(obj);
    }

    @Override
    public boolean canSaveToStorage() {
        return !this.isEmpty();
    }

    @Override
    public void write() {
        this.setDirty();
    }

    @Override
    @Generated
    public String toString() {
        return "PersistentDataContainerBlockEntity(super=" + super.toString() + ")";
    }
}

