/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.block.BlockSignPost;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.event.block.SignChangeEvent;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.ByteTag;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.IntTag;
import cn.nukkit.utils.BlockColor;
import cn.nukkit.utils.DyeColor;
import cn.nukkit.utils.TextFormat;
import java.util.Arrays;
import java.util.Objects;

public class BlockEntitySign
extends BlockEntitySpawnable {
    private String[] text;

    public BlockEntitySign(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.text = new String[4];
        if (!this.namedTag.contains("Text")) {
            if (this.namedTag.contains("FrontText")) {
                this.setText(((CompoundTag)this.namedTag.removeAndGet("FrontText")).getString("Text").split("\n", 4));
            } else {
                for (int i = 1; i <= 4; ++i) {
                    String line;
                    String key = "Text" + i;
                    if (!this.namedTag.contains(key)) continue;
                    this.text[i - 1] = line = this.namedTag.getString(key);
                    this.namedTag.remove(key);
                }
            }
        } else {
            String[] lines = this.namedTag.getString("Text").split("\n", 4);
            for (int i = 0; i < this.text.length; ++i) {
                this.text[i] = i < lines.length ? lines[i] : "";
            }
        }
        if (this.text != null) {
            BlockEntitySign.sanitizeText(this.text);
        }
        if (!(this.namedTag.get("SignTextColor") instanceof IntTag)) {
            this.setColor(DyeColor.BLACK.getSignColor());
        }
        if (!(this.namedTag.get("IgnoreLighting") instanceof ByteTag)) {
            this.setGlowing(false);
        }
        super.initBlockEntity();
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.remove("Creator");
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.getLevelBlock() instanceof BlockSignPost;
    }

    public boolean setText(String ... lines) {
        for (int i = 0; i < 4; ++i) {
            this.text[i] = i < lines.length ? lines[i] : "";
        }
        this.namedTag.putString("Text", String.join((CharSequence)"\n", this.text));
        this.setDirty();
        this.spawnToAll();
        return true;
    }

    public String[] getText() {
        return this.text;
    }

    public BlockColor getColor() {
        return new BlockColor(this.namedTag.getInt("SignTextColor"), true);
    }

    public void setColor(BlockColor color) {
        this.namedTag.putInt("SignTextColor", color.getARGB());
        this.setDirty();
    }

    public boolean isGlowing() {
        return this.namedTag.getBoolean("IgnoreLighting");
    }

    public void setGlowing(boolean glowing) {
        this.namedTag.putBoolean("IgnoreLighting", glowing);
        this.setDirty();
    }

    @Override
    public boolean updateCompoundTag(CompoundTag nbt, Player player) {
        if (!nbt.getString("id").equals("Sign")) {
            return false;
        }
        Object[] lines = new String[4];
        Arrays.fill(lines, "");
        String receivedText = nbt.getCompound("FrontText").getString("Text");
        String[] splitLines = receivedText.split("\n", 4);
        System.arraycopy(splitLines, 0, lines, 0, splitLines.length);
        BlockEntitySign.sanitizeText((String[])lines);
        SignChangeEvent signChangeEvent = new SignChangeEvent(this.getBlock(), player, (String[])lines);
        if (!this.namedTag.contains("Creator") || !Objects.equals(player.getUniqueId().toString(), this.namedTag.getString("Creator"))) {
            signChangeEvent.setCancelled();
        }
        if (player.getRemoveFormat()) {
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = TextFormat.clean((String)lines[i]);
            }
        }
        this.server.getPluginManager().callEvent(signChangeEvent);
        if (!signChangeEvent.isCancelled()) {
            this.setText(signChangeEvent.getLines());
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        return new CompoundTag().putString("id", "Sign").putString("Text", this.namedTag.getString("Text")).putInt("SignTextColor", this.getColor().getARGB()).putBoolean("IgnoreLighting", this.isGlowing()).putBoolean("TextIgnoreLegacyBugResolved", true).putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
    }

    private static void sanitizeText(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null) continue;
            lines[i] = lines[i].substring(0, Math.min(200, lines[i].length()));
        }
    }
}

