/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.item.Item;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.format.Chunk;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.IntTag;

public class BlockEntityLectern
extends BlockEntitySpawnable {
    private int totalPages;
    private Item item_;

    public BlockEntityLectern(Chunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        if (!(this.namedTag.get("book") instanceof CompoundTag)) {
            this.namedTag.remove("book");
        }
        if (!(this.namedTag.get("page") instanceof IntTag)) {
            this.namedTag.remove("page");
        }
        this.updateTotalPages(false);
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag c = new CompoundTag().putString("id", "Lectern").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        Item book = this.getBook();
        if (book.getId() != 0) {
            c.putCompound("book", NBTIO.putItemHelper(book));
            c.putBoolean("hasBook", true);
            c.putInt("page", this.getRawPage());
            c.putInt("totalPages", this.totalPages);
        } else {
            c.putBoolean("hasBook", false);
        }
        return c;
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.level.getBlockIdAt(this.chunk, (int)this.x, (int)this.y, (int)this.z) == 449;
    }

    @Override
    public void onBreak() {
        Item item = null;
        if (this.level.getGameRules().getBoolean(GameRule.DO_TILE_DROPS)) {
            item = this.getBook();
        }
        this.namedTag.remove("Item");
        this.item_ = null;
        if (item != null && item.getId() != 0) {
            this.level.dropItem(this, item);
        }
    }

    public boolean hasBook() {
        return this.namedTag.get("book") instanceof CompoundTag;
    }

    public Item getBook() {
        if (this.item_ != null) {
            return this.item_;
        }
        if (!this.hasBook()) {
            return Item.get(0, (Integer)0, 0);
        }
        this.item_ = NBTIO.getItemHelper(this.namedTag.getCompound("book"));
        return this.item_;
    }

    public void setBook(Item item) {
        if (item != null && (item.getId() == 387 || item.getId() == 386)) {
            this.item_ = item;
            this.namedTag.putCompound("book", NBTIO.putItemHelper(this.item_));
        } else {
            this.namedTag.remove("book");
            this.namedTag.remove("page");
            this.item_ = null;
        }
        this.updateTotalPages(true);
        this.setDirty();
    }

    public int getLeftPage() {
        return this.getRawPage() * 2 + 1;
    }

    public int getRightPage() {
        return this.getLeftPage() + 1;
    }

    public void setLeftPage(int newLeftPage) {
        this.setRawPage(newLeftPage - 1 >> 1);
    }

    public void setRightPage(int newRightPage) {
        this.setLeftPage(newRightPage - 1);
    }

    public void setRawPage(int page) {
        this.namedTag.putInt("page", Math.min(page, this.totalPages));
        this.setDirty();
        this.getLevel().updateAround(this);
    }

    public int getRawPage() {
        return this.namedTag.getInt("page");
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    private void updateTotalPages(boolean updateRedstone) {
        Item book = this.getBook();
        this.totalPages = book.getId() == 0 || !book.hasCompoundTag() ? 0 : book.getNamedTag().getList("pages", CompoundTag.class).size();
        if (updateRedstone) {
            this.getLevel().updateAroundRedstone(this, null);
        }
    }

    public boolean dropBook(Player player) {
        Item item = this.getBook();
        if (item != null && item.getId() != 0) {
            this.setBook(null);
            this.level.dropItem(this.add(0.5, 1.0, 0.5), item);
            return true;
        }
        return false;
    }

    @Override
    public void setDirty() {
        super.setDirty();
        this.spawnToAll();
    }
}

