/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntityItemFrameGlow;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.event.block.ItemFrameDropItemEvent;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.RuntimeItems;
import cn.nukkit.level.GameRule;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import java.util.concurrent.ThreadLocalRandom;

public class BlockEntityItemFrame
extends BlockEntitySpawnable {
    private Item item_;

    public BlockEntityItemFrame(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        if (!this.namedTag.contains("Item")) {
            this.item_ = new ItemBlock(Block.get(0));
            this.namedTag.putCompound("Item", NBTIO.putItemHelper(this.item_));
        }
        if (!this.namedTag.contains("ItemRotation")) {
            this.namedTag.putByte("ItemRotation", 0);
        }
        if (!this.namedTag.contains("ItemDropChance")) {
            this.namedTag.putFloat("ItemDropChance", 1.0f);
        }
        this.level.updateComparatorOutputLevel(this);
        super.initBlockEntity();
    }

    @Override
    public String getName() {
        return "Item Frame";
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.level.getBlockIdAt(this.chunk, (int)this.x, (int)this.y, (int)this.z) == 199;
    }

    public int getItemRotation() {
        return this.namedTag.getByte("ItemRotation");
    }

    public void setItemRotation(int itemRotation) {
        this.namedTag.putByte("ItemRotation", itemRotation);
        this.level.updateComparatorOutputLevel(this);
        this.setDirty();
    }

    public Item getItem() {
        if (this.item_ == null) {
            CompoundTag NBTTag = this.namedTag.getCompound("Item");
            this.item_ = NBTIO.getItemHelper(NBTTag);
        }
        return this.item_;
    }

    public void setItem(Item item) {
        this.setItem(item, true);
    }

    public void setItem(Item item, boolean setChanged) {
        this.item_ = item;
        this.namedTag.putCompound("Item", NBTIO.putItemHelper(item));
        if (setChanged) {
            this.setDirty();
        }
        this.level.updateComparatorOutputLevel(this);
    }

    public float getItemDropChance() {
        return this.namedTag.getFloat("ItemDropChance");
    }

    public void setItemDropChance(float chance) {
        this.namedTag.putFloat("ItemDropChance", chance);
        super.setDirty();
    }

    @Override
    public void setDirty() {
        super.setDirty();
        this.spawnToAll();
    }

    @Override
    public CompoundTag getSpawnCompound() {
        if (!this.namedTag.contains("Item")) {
            this.setItem(new ItemBlock(Block.get(0)), false);
        }
        CompoundTag itemOriginal = this.namedTag.getCompound("Item");
        CompoundTag tag = new CompoundTag().putString("id", this instanceof BlockEntityItemFrameGlow ? "GlowItemFrame" : "ItemFrame").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        int itemId = itemOriginal.getShort("id");
        if (itemId != 0) {
            CompoundTag item;
            if (itemId == 358) {
                item = itemOriginal.copy();
                item.setName("Item");
                String identifier = RuntimeItems.getMapping().toRuntime(itemId, itemOriginal.getShort("Damage")).getIdentifier();
                item.putString("Name", identifier);
                item.remove("id");
                item.getCompound("tag").remove("Colors");
            } else {
                item = new CompoundTag("Item").putByte("Count", itemOriginal.getByte("Count")).putShort("Damage", itemOriginal.getShort("Damage"));
                String identifier = RuntimeItems.getMapping().toRuntime(itemId, itemOriginal.getShort("Damage")).getIdentifier();
                item.putString("Name", identifier);
                if (itemOriginal.contains("tag")) {
                    CompoundTag oldTag = itemOriginal.getCompound("tag");
                    CompoundTag newTag = new CompoundTag();
                    if (oldTag.contains("ench")) {
                        newTag.putList(new ListTag("ench"));
                    }
                    if (oldTag.contains("Base")) {
                        newTag.put("Base", oldTag.get("Base"));
                    }
                    if (oldTag.contains("Patterns")) {
                        newTag.put("Patterns", oldTag.get("Patterns"));
                    }
                    if (oldTag.contains("customColor")) {
                        newTag.put("customColor", oldTag.get("customColor"));
                    }
                    if (oldTag.contains("display") && oldTag.get("display") instanceof CompoundTag) {
                        newTag.putCompound("display", new CompoundTag("display").putString("Name", ((CompoundTag)oldTag.get("display")).getString("Name")));
                    }
                    item.put("tag", newTag);
                }
            }
            tag.putCompound("Item", item).putByte("ItemRotation", this.getItemRotation());
        }
        return tag;
    }

    public int getAnalogOutput() {
        return this.getItem() == null || this.getItem().getId() == 0 ? 0 : this.getItemRotation() % 8 + 1;
    }

    public boolean dropItem(Player player) {
        Item item = this.getItem();
        if (item != null && item.getId() != 0) {
            if (player != null) {
                ItemFrameDropItemEvent event = new ItemFrameDropItemEvent(player, this.getBlock(), this, item);
                this.level.getServer().getPluginManager().callEvent(event);
                if (event.isCancelled()) {
                    this.spawnTo(player);
                    return true;
                }
            }
            this.setItem(Item.get(0));
            this.setItemRotation(0);
            if (this.getItemDropChance() > ThreadLocalRandom.current().nextFloat()) {
                this.level.dropItem(this.add(0.5, 0.0, 0.5), item);
            }
            this.level.addLevelEvent(this, 1043);
            return true;
        }
        return false;
    }

    @Override
    public void onBreak() {
        Item item = null;
        if (this.level.getGameRules().getBoolean(GameRule.DO_TILE_DROPS)) {
            item = this.getItem();
        }
        this.namedTag.remove("Item");
        this.item_ = null;
        if (item != null && item.getId() != 0) {
            this.level.dropItem(this, item);
        }
    }
}

