/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.block.BlockComposter;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityBrewingStand;
import cn.nukkit.blockentity.BlockEntityContainer;
import cn.nukkit.blockentity.BlockEntityFurnace;
import cn.nukkit.blockentity.BlockEntityNameable;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.entity.Entity;
import cn.nukkit.entity.item.EntityItem;
import cn.nukkit.event.inventory.InventoryMoveItemEvent;
import cn.nukkit.inventory.BrewingInventory;
import cn.nukkit.inventory.Fuel;
import cn.nukkit.inventory.FurnaceInventory;
import cn.nukkit.inventory.HopperInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.AxisAlignedBB;
import cn.nukkit.math.BlockFace;
import cn.nukkit.math.SimpleAxisAlignedBB;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import java.util.ArrayList;
import lombok.Generated;

public class BlockEntityHopper
extends BlockEntitySpawnable
implements InventoryHolder,
BlockEntityContainer,
BlockEntityNameable {
    protected HopperInventory inventory;
    public int transferCooldown;
    private AxisAlignedBB pickupArea;
    private InventoryHolder minecartPickupInventory;
    private InventoryHolder minecartPushInventory;

    public BlockEntityHopper(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.transferCooldown = this.namedTag.contains("TransferCooldown") ? this.namedTag.getInt("TransferCooldown") : 8;
        this.inventory = new HopperInventory(this);
        if (!this.namedTag.contains("Items") || !(this.namedTag.get("Items") instanceof ListTag)) {
            this.namedTag.putList(new ListTag("Items"));
        }
        ListTag<? extends Tag> list = this.namedTag.getList("Items");
        for (CompoundTag compoundTag : list.getAll()) {
            Item item = NBTIO.getItemHelper(compoundTag);
            if (item.getId() == 0 || item.getCount() <= 0) continue;
            this.inventory.slots.put(compoundTag.getByte("Slot"), item);
        }
        this.pickupArea = new SimpleAxisAlignedBB(this.x, this.y, this.z, this.x + 1.0, this.y + 2.0, this.z + 1.0);
        this.scheduleUpdate();
        super.initBlockEntity();
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.level.getBlockIdAt(this.chunk, (int)this.x, (int)this.y, (int)this.z) == 154;
    }

    @Override
    public String getName() {
        return this.hasName() ? this.namedTag.getString("CustomName") : "Hopper";
    }

    @Override
    public boolean hasName() {
        return this.namedTag.contains("CustomName");
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            this.namedTag.remove("CustomName");
            return;
        }
        this.namedTag.putString("CustomName", name);
    }

    public boolean isOnTransferCooldown() {
        return this.transferCooldown > 0;
    }

    public void setTransferCooldown(int transferCooldown) {
        this.transferCooldown = transferCooldown;
    }

    @Override
    public int getSize() {
        return 5;
    }

    protected int getSlotIndex(int index) {
        ListTag<CompoundTag> list = this.namedTag.getList("Items", CompoundTag.class);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getByte("Slot") != index) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Item getItem(int index) {
        int i = this.getSlotIndex(index);
        if (i < 0) {
            return new ItemBlock(Block.get(0), 0, 0);
        }
        CompoundTag data = (CompoundTag)this.namedTag.getList("Items").get(i);
        return NBTIO.getItemHelper(data);
    }

    @Override
    public void setItem(int index, Item item) {
        int i = this.getSlotIndex(index);
        CompoundTag d = NBTIO.putItemHelper(item, index);
        if (item.getId() == 0 || item.getCount() <= 0) {
            if (i >= 0) {
                this.namedTag.getList("Items").getAll().remove(i);
            }
        } else if (i < 0) {
            this.namedTag.getList("Items", CompoundTag.class).add(d);
        } else {
            this.namedTag.getList("Items", CompoundTag.class).add(i, d);
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putList(new ListTag("Items"));
        for (int index = 0; index < this.getSize(); ++index) {
            this.setItem(index, this.inventory.getItem(index));
        }
        this.namedTag.putInt("TransferCooldown", this.transferCooldown);
    }

    @Override
    public HopperInventory getInventory() {
        return this.inventory;
    }

    @Override
    public boolean onUpdate() {
        if (this.closed) {
            return false;
        }
        --this.transferCooldown;
        if (!this.isOnTransferCooldown()) {
            boolean changed;
            if (this.level.isBlockPowered(this.chunk, this)) {
                return true;
            }
            boolean bl = changed = !this.inventory.slots.isEmpty() && (this.pushItems() || this.pushItemsToMinecart());
            if (!changed && !this.inventory.isFull()) {
                BlockEntity blockEntity = this.level.getBlockEntity(this.chunk, this.up());
                Block block = null;
                if (blockEntity instanceof BlockEntityContainer || (block = this.level.getBlock(this.chunk, this.getFloorX(), this.getFloorY() + 1, this.getFloorZ(), false)) instanceof BlockComposter) {
                    changed = this.pullItems(blockEntity, block);
                } else {
                    boolean bl2 = changed = this.pullItemsFromMinecart() || this.pickupItems();
                }
            }
            if (changed) {
                this.setTransferCooldown(8);
                this.setDirty();
            }
        }
        return true;
    }

    private boolean pullItemsFromMinecart() {
        if (this.minecartPickupInventory != null) {
            Inventory inv = this.minecartPickupInventory.getInventory();
            for (int i = 0; i < inv.getSize(); ++i) {
                Item item = inv.getItem(i);
                if (item.isNull()) continue;
                Item itemToAdd = item.clone();
                itemToAdd.count = 1;
                if (!this.inventory.canAddItem(itemToAdd)) continue;
                InventoryMoveItemEvent ev = new InventoryMoveItemEvent(inv, this.inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) continue;
                Item[] items = this.inventory.addItem(itemToAdd);
                if (items.length >= 1) continue;
                --item.count;
                inv.setItem(i, item);
                this.minecartPickupInventory = null;
                return true;
            }
        }
        return false;
    }

    private boolean pushItemsToMinecart() {
        if (this.minecartPushInventory != null) {
            Inventory holderInventory = this.minecartPushInventory.getInventory();
            if (holderInventory.isFull()) {
                return false;
            }
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                Item item = this.inventory.getItem(i);
                if (item.isNull()) continue;
                Item itemToAdd = item.clone();
                itemToAdd.setCount(1);
                if (!holderInventory.canAddItem(itemToAdd)) continue;
                InventoryMoveItemEvent ev = new InventoryMoveItemEvent(this.inventory, holderInventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) continue;
                Item[] items = holderInventory.addItem(itemToAdd);
                if (items.length > 0) continue;
                --item.count;
                this.inventory.setItem(i, item);
                this.minecartPushInventory = null;
                return true;
            }
        }
        return false;
    }

    public boolean pullItems() {
        return this.pullItems(this.level.getBlockEntity(this.chunk, this.up()), this.level.getBlock(this.chunk, this.getFloorX(), this.getFloorY() + 1, this.getFloorZ(), false));
    }

    private boolean pullItems(BlockEntity blockEntity, Block block) {
        if (blockEntity instanceof BlockEntityFurnace) {
            FurnaceInventory inv = ((BlockEntityFurnace)blockEntity).getInventory();
            Item item = inv.getResult();
            if (!item.isNull()) {
                Item itemToAdd = item.clone();
                itemToAdd.count = 1;
                if (!this.inventory.canAddItem(itemToAdd)) {
                    return false;
                }
                InventoryMoveItemEvent ev = new InventoryMoveItemEvent(inv, this.inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled()) {
                    return false;
                }
                Item[] items = this.inventory.addItem(itemToAdd);
                if (items.length == 0) {
                    --item.count;
                    inv.setResult(item);
                    return true;
                }
            }
        } else if (blockEntity instanceof InventoryHolder) {
            Inventory inv = ((InventoryHolder)((Object)blockEntity)).getInventory();
            for (int i = 0; i < inv.getSize(); ++i) {
                Item[] items;
                Item item = inv.getItem(i);
                if (item.isNull()) continue;
                Item itemToAdd = item.clone();
                itemToAdd.count = 1;
                if (!this.inventory.canAddItem(itemToAdd)) continue;
                InventoryMoveItemEvent ev = new InventoryMoveItemEvent(inv, this.inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                this.server.getPluginManager().callEvent(ev);
                if (ev.isCancelled() || (items = this.inventory.addItem(itemToAdd)).length >= 1) continue;
                --item.count;
                inv.setItem(i, item);
                return true;
            }
        } else if (block instanceof BlockComposter) {
            BlockComposter composter = (BlockComposter)block;
            Item item = composter.empty();
            if (item == null || item.isNull()) {
                return false;
            }
            Item itemToAdd = item.clone();
            itemToAdd.setCount(1);
            if (!this.inventory.canAddItem(itemToAdd)) {
                return false;
            }
            InventoryMoveItemEvent ev = new InventoryMoveItemEvent(null, this.inventory, this, item, InventoryMoveItemEvent.Action.PICKUP);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) {
                return false;
            }
            Item[] items = this.inventory.addItem(itemToAdd);
            return items.length < 1;
        }
        return false;
    }

    public boolean pickupItems() {
        boolean pickedUpItem = false;
        for (Entity entity : this.level.getCollidingEntities(this.pickupArea)) {
            EntityItem itemEntity;
            Item item;
            if (entity.isClosed() || !(entity instanceof EntityItem) || (item = (itemEntity = (EntityItem)entity).getItem()).isNull()) continue;
            int originalCount = item.getCount();
            if (!this.inventory.canAddItem(item)) continue;
            InventoryMoveItemEvent ev = new InventoryMoveItemEvent(null, this.inventory, this, item, InventoryMoveItemEvent.Action.PICKUP);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled()) continue;
            Item[] items = this.inventory.addItem(item);
            if (items.length == 0) {
                entity.close();
                pickedUpItem = true;
                continue;
            }
            if (items[0].getCount() == originalCount) continue;
            pickedUpItem = true;
            item.setCount(items[0].getCount());
        }
        return pickedUpItem;
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (Player player : new ArrayList<Player>(this.inventory.getViewers())) {
                player.removeWindow(this.inventory);
            }
            super.close();
        }
    }

    @Override
    public void onBreak() {
        for (Item content : this.inventory.getContents().values()) {
            this.level.dropItem(this, content);
        }
        this.inventory.clearAll();
    }

    public boolean pushItems() {
        int blockData = this.level.getBlockDataAt(this.chunk, (int)this.x, (int)this.y, (int)this.z, Block.LAYER_NORMAL);
        BlockEntity be = this.level.getBlockEntity(this.chunk, this.getSide(BlockFace.fromIndex(blockData)));
        if (!(be instanceof InventoryHolder) || be instanceof BlockEntityHopper && blockData == 0) {
            return false;
        }
        if (be instanceof BlockEntityFurnace) {
            FurnaceInventory inventory = ((BlockEntityFurnace)be).getInventory();
            if (inventory.isFull()) {
                return false;
            }
            boolean pushedItem = false;
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                InventoryMoveItemEvent event;
                Item item = this.inventory.getItem(i);
                if (item.isNull()) continue;
                Item itemToAdd = item.clone();
                itemToAdd.setCount(1);
                if (blockData == 0) {
                    Item smelting = inventory.getSmelting();
                    if (smelting.isNull()) {
                        event = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            inventory.setSmelting(itemToAdd);
                            --item.count;
                            pushedItem = true;
                        }
                    } else if (smelting.getId() == itemToAdd.getId() && smelting.getDamage() == itemToAdd.getDamage() && smelting.count < smelting.getMaxStackSize()) {
                        event = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            ++smelting.count;
                            inventory.setSmelting(smelting);
                            --item.count;
                            pushedItem = true;
                        }
                    }
                } else if (Fuel.duration.containsKey(itemToAdd.getId())) {
                    Item fuel = inventory.getFuel();
                    if (fuel.isNull()) {
                        event = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            inventory.setFuel(itemToAdd);
                            --item.count;
                            pushedItem = true;
                        }
                    } else if (fuel.getId() == itemToAdd.getId() && fuel.getDamage() == itemToAdd.getDamage() && fuel.count < fuel.getMaxStackSize()) {
                        event = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            ++fuel.count;
                            inventory.setFuel(fuel);
                            --item.count;
                            pushedItem = true;
                        }
                    }
                }
                if (!pushedItem) continue;
                this.inventory.setItem(i, item);
                return true;
            }
            return false;
        }
        if (be instanceof BlockEntityBrewingStand) {
            BrewingInventory inventory = ((BlockEntityBrewingStand)be).getInventory();
            if (inventory.isFull()) {
                return false;
            }
            boolean pushedItem = false;
            for (int i = 0; i < this.inventory.getSize(); ++i) {
                InventoryMoveItemEvent event;
                boolean isPotion;
                Item item = this.inventory.getItem(i);
                if (item.isNull()) continue;
                Item itemToAdd = item.clone();
                itemToAdd.setCount(1);
                boolean bl = isPotion = itemToAdd.getId() == 374 || itemToAdd.getId() == 373 || itemToAdd.getId() == 438;
                if (blockData == 0) {
                    if (isPotion) continue;
                    Item ingredient = inventory.getIngredient();
                    if (ingredient.isNull()) {
                        event = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            inventory.setIngredient(itemToAdd);
                            pushedItem = true;
                        }
                    } else if (ingredient.getId() == itemToAdd.getId() && ingredient.getDamage() == itemToAdd.getDamage() && ingredient.count < ingredient.getMaxStackSize()) {
                        event = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            ++ingredient.count;
                            inventory.setIngredient(ingredient);
                            pushedItem = true;
                        }
                    }
                } else if (itemToAdd.getId() == 377) {
                    Item fuel = inventory.getFuel();
                    if (fuel.isNull()) {
                        event = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            inventory.setFuel(itemToAdd);
                            pushedItem = true;
                        }
                    } else if (fuel.getId() == itemToAdd.getId() && fuel.getDamage() == itemToAdd.getDamage() && fuel.count < fuel.getMaxStackSize()) {
                        event = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
                        this.server.getPluginManager().callEvent(event);
                        if (!event.isCancelled()) {
                            ++fuel.count;
                            inventory.setFuel(fuel);
                            pushedItem = true;
                        }
                    }
                } else if (isPotion) {
                    if (inventory.addItem(itemToAdd).length > 0) continue;
                    pushedItem = true;
                }
                if (!pushedItem) continue;
                --item.count;
                this.inventory.setItem(i, item);
                return true;
            }
            return false;
        }
        Inventory inventory = ((InventoryHolder)((Object)be)).getInventory();
        if (inventory.isFull()) {
            return false;
        }
        for (int i = 0; i < this.inventory.getSize(); ++i) {
            Item[] items;
            Item item = this.inventory.getItem(i);
            if (item.isNull()) continue;
            Item itemToAdd = item.clone();
            itemToAdd.setCount(1);
            if (!inventory.canAddItem(itemToAdd)) continue;
            InventoryMoveItemEvent ev = new InventoryMoveItemEvent(this.inventory, inventory, this, itemToAdd, InventoryMoveItemEvent.Action.SLOT_CHANGE);
            this.server.getPluginManager().callEvent(ev);
            if (ev.isCancelled() || (items = inventory.addItem(itemToAdd)).length > 0) continue;
            --item.count;
            this.inventory.setItem(i, item);
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag c = new CompoundTag().putString("id", "Hopper").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (this.hasName()) {
            c.put("CustomName", this.namedTag.get("CustomName"));
        }
        return c;
    }

    @Generated
    public void setMinecartPickupInventory(InventoryHolder minecartPickupInventory) {
        this.minecartPickupInventory = minecartPickupInventory;
    }

    @Generated
    public void setMinecartPushInventory(InventoryHolder minecartPushInventory) {
        this.minecartPushInventory = minecartPushInventory;
    }
}

