/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntityBlastFurnace;
import cn.nukkit.blockentity.BlockEntityContainer;
import cn.nukkit.blockentity.BlockEntityNameable;
import cn.nukkit.blockentity.BlockEntitySmoker;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.event.inventory.FurnaceBurnEvent;
import cn.nukkit.event.inventory.FurnaceSmeltEvent;
import cn.nukkit.inventory.BlastFurnaceInventory;
import cn.nukkit.inventory.FurnaceInventory;
import cn.nukkit.inventory.FurnaceRecipe;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.inventory.SmokerInventory;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.NukkitMath;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import cn.nukkit.network.protocol.ContainerSetDataPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class BlockEntityFurnace
extends BlockEntitySpawnable
implements InventoryHolder,
BlockEntityContainer,
BlockEntityNameable {
    protected FurnaceInventory inventory;
    protected int burnTime;
    protected int burnDuration;
    protected int cookTime;
    protected int maxTime;
    protected int crackledTime;
    protected double experience;
    public static final Map<Integer, Double> FURNACE_XP = new HashMap<Integer, Double>();

    public BlockEntityFurnace(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        this.inventory = this instanceof BlockEntityBlastFurnace ? new BlastFurnaceInventory((BlockEntityBlastFurnace)this) : (this instanceof BlockEntitySmoker ? new SmokerInventory((BlockEntitySmoker)this) : new FurnaceInventory(this));
        if (!this.namedTag.contains("Items") || !(this.namedTag.get("Items") instanceof ListTag)) {
            this.namedTag.putList(new ListTag("Items"));
        }
        ListTag<? extends Tag> list = this.namedTag.getList("Items");
        for (CompoundTag compoundTag : list.getAll()) {
            Item item = NBTIO.getItemHelper(compoundTag);
            if (item.getId() == 0 || item.getCount() <= 0) continue;
            this.inventory.slots.put(compoundTag.getByte("Slot"), item);
        }
        this.burnTime = !this.namedTag.contains("BurnTime") || this.namedTag.getShort("BurnTime") < 0 ? 0 : this.namedTag.getShort("BurnTime");
        this.cookTime = !this.namedTag.contains("CookTime") || this.namedTag.getShort("CookTime") < 0 || this.namedTag.getShort("BurnTime") == 0 && this.namedTag.getShort("CookTime") > 0 ? 0 : this.namedTag.getShort("CookTime");
        this.burnDuration = !this.namedTag.contains("BurnDuration") || this.namedTag.getShort("BurnDuration") < 0 ? 0 : this.namedTag.getShort("BurnDuration");
        if (!this.namedTag.contains("MaxTime")) {
            this.maxTime = this.burnTime;
            this.burnDuration = 0;
        } else {
            this.maxTime = this.namedTag.getShort("MaxTime");
        }
        if (this.namedTag.contains("BurnTicks")) {
            this.burnDuration = this.namedTag.getShort("BurnTicks");
            this.namedTag.remove("BurnTicks");
        }
        this.experience = this.namedTag.contains("Experience") && this.namedTag.getDouble("Experience") > 0.0 ? this.namedTag.getDouble("Experience") : 0.0;
        if (this.burnTime > 0) {
            this.scheduleUpdate();
        }
        super.initBlockEntity();
    }

    @Override
    public String getName() {
        return this.hasName() ? this.namedTag.getString("CustomName") : "Furnace";
    }

    @Override
    public boolean hasName() {
        return this.namedTag.contains("CustomName");
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            this.namedTag.remove("CustomName");
            return;
        }
        this.namedTag.putString("CustomName", name);
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (Player player : new ArrayList<Player>(this.inventory.getViewers())) {
                player.removeWindow(this.inventory);
            }
            super.close();
        }
    }

    @Override
    public void onBreak() {
        for (Item content : this.inventory.getContents().values()) {
            this.level.dropItem(this, content);
        }
        this.inventory.clearAll();
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putList(new ListTag("Items"));
        for (int index = 0; index < this.getSize(); ++index) {
            this.setItem(index, this.inventory.getItem(index));
        }
        this.namedTag.putShort("CookTime", this.cookTime);
        this.namedTag.putShort("BurnTime", this.burnTime);
        this.namedTag.putShort("BurnDuration", this.burnDuration);
        this.namedTag.putShort("MaxTime", this.maxTime);
        this.namedTag.putDouble("Experience", this.experience);
    }

    @Override
    public boolean isBlockEntityValid() {
        int blockID = this.level.getBlockIdAt(this.chunk, (int)this.x, (int)this.y, (int)this.z);
        return blockID == 61 || blockID == 62;
    }

    @Override
    public int getSize() {
        return 3;
    }

    protected int getSlotIndex(int index) {
        ListTag<CompoundTag> list = this.namedTag.getList("Items", CompoundTag.class);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getByte("Slot") != index) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Item getItem(int index) {
        int i = this.getSlotIndex(index);
        if (i < 0) {
            return new ItemBlock(Block.get(0), 0, 0);
        }
        CompoundTag data = (CompoundTag)this.namedTag.getList("Items").get(i);
        return NBTIO.getItemHelper(data);
    }

    @Override
    public void setItem(int index, Item item) {
        int i = this.getSlotIndex(index);
        CompoundTag d = NBTIO.putItemHelper(item, index);
        if (item.getId() == 0 || item.getCount() <= 0) {
            if (i >= 0) {
                this.namedTag.getList("Items").getAll().remove(i);
            }
        } else if (i < 0) {
            this.namedTag.getList("Items", CompoundTag.class).add(d);
        } else {
            this.namedTag.getList("Items", CompoundTag.class).add(i, d);
        }
    }

    @Override
    public FurnaceInventory getInventory() {
        return this.inventory;
    }

    protected void checkFuel(Item fuel) {
        FurnaceBurnEvent ev = new FurnaceBurnEvent(this, fuel, fuel.getFuelTime() == null ? (short)0 : fuel.getFuelTime());
        this.server.getPluginManager().callEvent(ev);
        if (ev.isCancelled()) {
            return;
        }
        this.maxTime = ev.getBurnTime();
        this.burnTime = ev.getBurnTime();
        this.burnDuration = 0;
        Block block = this.level.getBlock(this.chunk, (int)this.x, (int)this.y, (int)this.z, true);
        if (block.getId() == 61) {
            this.getLevel().setBlock(this, Block.get(62, block.getDamage()), true);
        } else if (block.getId() == 453) {
            this.getLevel().setBlock(this, Block.get(454, block.getDamage()), true);
        } else if (block.getId() == 451) {
            this.getLevel().setBlock(this, Block.get(469, block.getDamage()), true);
        }
        if (this.burnTime > 0 && ev.isBurning()) {
            fuel.setCount(fuel.getCount() - 1);
            if (fuel.getCount() == 0) {
                if (fuel.getId() == 325 && fuel.getDamage() == 10) {
                    fuel.setDamage(0);
                    fuel.setCount(1);
                } else {
                    fuel = new ItemBlock(Block.get(0), 0, 0);
                }
            }
            this.inventory.setFuel(fuel);
        }
    }

    @Override
    public boolean onUpdate() {
        Item fuel;
        boolean canSmelt;
        if (this.closed) {
            return false;
        }
        boolean ret = false;
        Item raw = this.inventory.getSmelting();
        Item product = this.inventory.getResult();
        FurnaceRecipe smelt = this.server.getCraftingManager().matchFurnaceRecipe(raw);
        boolean bl = canSmelt = smelt != null && raw.getCount() > 0 && (smelt.getResult().equals(product) && product.getCount() < product.getMaxStackSize() || product.getId() == 0);
        if (this.burnTime <= 0 && canSmelt && (fuel = this.inventory.getItemFast(1)).getFuelTime() != null && fuel.getCount() > 0) {
            this.checkFuel(fuel.clone());
        }
        if (this.burnTime > 0) {
            --this.burnTime;
            this.burnDuration = (int)Math.ceil((float)this.burnTime / (float)this.maxTime * 200.0f);
            if (this.crackledTime-- <= 0) {
                this.crackledTime = ThreadLocalRandom.current().nextInt(30, 110);
                this.getLevel().addLevelSoundEvent(this.add(0.5, 0.5, 0.5), 283);
            }
            if (smelt != null && canSmelt) {
                ++this.cookTime;
                if (this.cookTime >= 200) {
                    product = Item.get(smelt.getResult().getId(), (Integer)smelt.getResult().getDamage(), product.isNull() ? 1 : product.getCount() + 1);
                    FurnaceSmeltEvent ev = new FurnaceSmeltEvent(this, raw, product);
                    this.server.getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        this.inventory.setResult(ev.getResult());
                        this.experience += FURNACE_XP.getOrDefault(ev.getResult().getId(), 0.0).doubleValue();
                        raw.setCount(raw.getCount() - 1);
                        if (raw.getCount() == 0) {
                            raw = new ItemBlock(Block.get(0), 0, 0);
                        }
                        this.inventory.setSmelting(raw);
                    }
                    this.cookTime -= 200;
                }
            } else if (this.burnTime <= 0) {
                this.burnTime = 0;
                this.cookTime = 0;
                this.burnDuration = 0;
            } else {
                this.cookTime = 0;
            }
            ret = true;
        } else {
            Block block = this.level.getBlock(this.chunk, (int)this.x, (int)this.y, (int)this.z, true);
            if (block.getId() == 62) {
                this.getLevel().setBlock(this, Block.get(61, block.getDamage()), true);
            }
            this.burnTime = 0;
            this.cookTime = 0;
            this.burnDuration = 0;
            this.crackledTime = 0;
        }
        this.sendPacket();
        return ret;
    }

    protected void sendPacket() {
        for (Player player : this.inventory.getViewers()) {
            int windowId = player.getWindowId(this.inventory);
            if (windowId <= 0) continue;
            ContainerSetDataPacket pk = new ContainerSetDataPacket();
            pk.windowId = windowId;
            pk.property = 0;
            pk.value = this.cookTime;
            player.dataPacket(pk);
            pk = new ContainerSetDataPacket();
            pk.windowId = windowId;
            pk.property = 1;
            pk.value = this.burnDuration;
            player.dataPacket(pk);
        }
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag c = new CompoundTag().putString("id", "Furnace").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putShort("BurnDuration", this.burnDuration).putShort("BurnTime", this.burnTime).putShort("CookTime", this.cookTime);
        if (this.hasName()) {
            c.put("CustomName", this.namedTag.get("CustomName"));
        }
        return c;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getBurnDuration() {
        return this.burnDuration;
    }

    public void setBurnDuration(int burnDuration) {
        this.burnDuration = burnDuration;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public void setCookTime(int cookTime) {
        this.cookTime = cookTime;
    }

    public int getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(int maxTime) {
        this.maxTime = maxTime;
    }

    public double getExperience() {
        return this.experience;
    }

    public void setExperience(double experience) {
        this.experience = experience;
    }

    public void releaseExperience() {
        int experience = NukkitMath.floorDouble(this.experience);
        if (experience >= 1) {
            this.experience = 0.0;
            this.level.dropExpOrb(this, experience);
        }
    }

    static {
        FURNACE_XP.put(393, 0.35);
        FURNACE_XP.put(464, 0.1);
        FURNACE_XP.put(364, 0.35);
        FURNACE_XP.put(320, 0.35);
        FURNACE_XP.put(424, 0.35);
        FURNACE_XP.put(366, 0.35);
        FURNACE_XP.put(412, 0.35);
        FURNACE_XP.put(350, 0.35);
        FURNACE_XP.put(463, 0.35);
        FURNACE_XP.put(331, 0.3);
        FURNACE_XP.put(263, 0.1);
        FURNACE_XP.put(388, 1.0);
        FURNACE_XP.put(351, 0.2);
        FURNACE_XP.put(264, 1.0);
        FURNACE_XP.put(406, 0.2);
        FURNACE_XP.put(265, 0.7);
        FURNACE_XP.put(519, 0.7);
        FURNACE_XP.put(266, 1.0);
        FURNACE_XP.put(752, 1.0);
        FURNACE_XP.put(452, 0.1);
        FURNACE_XP.put(371, 0.1);
        FURNACE_XP.put(1, 0.1);
        FURNACE_XP.put(172, 0.35);
        FURNACE_XP.put(20, 0.1);
        FURNACE_XP.put(19, 0.15);
        FURNACE_XP.put(433, 0.1);
        FURNACE_XP.put(336, 0.3);
        FURNACE_XP.put(405, 0.1);
        FURNACE_XP.put(-377, 0.1);
    }
}

