/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public class BlockEntityFlowerPot
extends BlockEntitySpawnable {
    private static final Int2ObjectOpenHashMap<String> HAS_STRING_ITEM_OVERRIDE = new Int2ObjectOpenHashMap();

    public BlockEntityFlowerPot(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        if (!this.namedTag.contains("item")) {
            this.namedTag.putShort("item", 0);
        }
        if (!this.namedTag.contains("data")) {
            if (this.namedTag.contains("mData")) {
                this.namedTag.putInt("data", this.namedTag.getInt("mData"));
                this.namedTag.remove("mData");
            } else {
                this.namedTag.putInt("data", 0);
            }
        }
        super.initBlockEntity();
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.level.getBlockIdAt(this.chunk, (int)this.x, (int)this.y, (int)this.z) == 140;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag tag = new CompoundTag().putString("id", "FlowerPot").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        int item = this.namedTag.getShort("item");
        if (item != 0) {
            if (HAS_STRING_ITEM_OVERRIDE.containsKey(item)) {
                tag.putCompound("PlantBlock", new CompoundTag().putString("name", HAS_STRING_ITEM_OVERRIDE.get(item)));
            } else {
                tag.putShort("item", this.namedTag.getShort("item")).putInt("mData", this.namedTag.getInt("data"));
            }
        }
        return tag;
    }

    static {
        HAS_STRING_ITEM_OVERRIDE.put(478, "minecraft:crimson_roots");
        HAS_STRING_ITEM_OVERRIDE.put(479, "minecraft:warped_roots");
        HAS_STRING_ITEM_OVERRIDE.put(483, "minecraft:crimson_fungus");
        HAS_STRING_ITEM_OVERRIDE.put(484, "minecraft:warped_fungus");
    }
}

