/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;

public class BlockEntityComparator
extends BlockEntity {
    private int outputSignal;

    public BlockEntityComparator(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
        if (!nbt.contains("OutputSignal")) {
            nbt.putInt("OutputSignal", 0);
        }
        this.outputSignal = nbt.getInt("OutputSignal");
    }

    @Override
    public boolean isBlockEntityValid() {
        int blockID = this.level.getBlockIdAt(this.chunk, (int)this.x, (int)this.y, (int)this.z);
        return blockID == 150 || blockID == 149;
    }

    public int getOutputSignal() {
        return this.outputSignal;
    }

    public void setOutputSignal(int outputSignal) {
        if (this.outputSignal != outputSignal) {
            this.outputSignal = outputSignal;
            this.setDirty();
        }
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        this.namedTag.putInt("OutputSignal", this.outputSignal);
    }
}

