/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntity;
import cn.nukkit.blockentity.BlockEntityContainer;
import cn.nukkit.blockentity.BlockEntityNameable;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.inventory.BaseInventory;
import cn.nukkit.inventory.ChestInventory;
import cn.nukkit.inventory.DoubleChestInventory;
import cn.nukkit.inventory.InventoryHolder;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.math.Vector3;
import cn.nukkit.nbt.NBTIO;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.nbt.tag.ListTag;
import cn.nukkit.nbt.tag.Tag;
import java.util.ArrayList;

public class BlockEntityChest
extends BlockEntitySpawnable
implements InventoryHolder,
BlockEntityContainer,
BlockEntityNameable {
    protected ChestInventory inventory;
    protected DoubleChestInventory doubleInventory;

    public BlockEntityChest(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    private void initInventory() {
        if (!this.namedTag.contains("Items") || !(this.namedTag.get("Items") instanceof ListTag)) {
            this.namedTag.putList(new ListTag("Items"));
        }
        ListTag<? extends Tag> list = this.namedTag.getList("Items");
        this.inventory = new ChestInventory(this);
        for (CompoundTag compoundTag : list.getAll()) {
            Item item = NBTIO.getItemHelper(compoundTag);
            if (item.getId() == 0 || item.getCount() <= 0) continue;
            this.inventory.slots.put(compoundTag.getByte("Slot"), item);
        }
    }

    @Override
    public void close() {
        if (!this.closed && this.inventory != null) {
            if (this.doubleInventory != null) {
                for (Player player : new ArrayList<Player>(this.doubleInventory.getViewers())) {
                    player.removeWindow(this.doubleInventory);
                }
                this.doubleInventory = null;
            }
            for (Player player : new ArrayList<Player>(this.inventory.getViewers())) {
                player.removeWindow(this.inventory);
            }
        }
        super.close();
    }

    @Override
    public void onBreak() {
        if (this.inventory == null) {
            this.initInventory();
        }
        this.unpair();
        for (Item content : this.inventory.getContents().values()) {
            this.level.dropItem(this, content);
        }
        this.inventory.clearAll();
    }

    @Override
    public void saveNBT() {
        super.saveNBT();
        if (this.inventory != null) {
            this.namedTag.putList(new ListTag("Items"));
            for (int index = 0; index < this.getSize(); ++index) {
                this.setItem(index, this.inventory.getItem(index));
            }
        }
    }

    @Override
    public boolean isBlockEntityValid() {
        int id = this.level.getBlockIdAt(this.chunk, (int)this.x, (int)this.y, (int)this.z);
        return id == 54 || id == 146;
    }

    @Override
    public int getSize() {
        return 27;
    }

    protected int getSlotIndex(int index) {
        ListTag<CompoundTag> list = this.namedTag.getList("Items", CompoundTag.class);
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).getByte("Slot") != index) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Item getItem(int index) {
        int i = this.getSlotIndex(index);
        if (i < 0) {
            return new ItemBlock(Block.get(0), 0, 0);
        }
        CompoundTag data = (CompoundTag)this.namedTag.getList("Items").get(i);
        return NBTIO.getItemHelper(data);
    }

    @Override
    public void setItem(int index, Item item) {
        int i = this.getSlotIndex(index);
        CompoundTag d = NBTIO.putItemHelper(item, index);
        if (item.getId() == 0 || item.getCount() <= 0) {
            if (i >= 0) {
                this.namedTag.getList("Items").remove(i);
            }
        } else if (i < 0) {
            this.namedTag.getList("Items", CompoundTag.class).add(d);
        } else {
            this.namedTag.getList("Items", CompoundTag.class).add(i, d);
        }
    }

    @Override
    public BaseInventory getInventory() {
        if (this.inventory == null) {
            this.initInventory();
        }
        if (this.doubleInventory == null && this.isPaired()) {
            this.checkPairing();
        }
        return this.doubleInventory != null ? this.doubleInventory : this.inventory;
    }

    public ChestInventory getRealInventory() {
        if (this.inventory == null) {
            this.initInventory();
        }
        return this.inventory;
    }

    protected void checkPairing() {
        BlockEntityChest pair = this.getPair();
        if (pair != null) {
            if (!pair.isPaired()) {
                pair.createPair(this);
                pair.checkPairing();
            }
            if (pair.doubleInventory != null) {
                this.doubleInventory = pair.doubleInventory;
            } else if (this.doubleInventory == null) {
                this.doubleInventory = pair.x + (double)((int)pair.z << 15) > this.x + (double)((int)this.z << 15) ? new DoubleChestInventory(pair, this) : new DoubleChestInventory(this, pair);
            }
        } else if (this.level.isChunkLoaded(this.namedTag.getInt("pairx") >> 4, this.namedTag.getInt("pairz") >> 4)) {
            this.doubleInventory = null;
            this.namedTag.remove("pairx");
            this.namedTag.remove("pairz");
        }
    }

    @Override
    public String getName() {
        return this.hasName() ? this.namedTag.getString("CustomName") : "Chest";
    }

    @Override
    public boolean hasName() {
        return this.namedTag.contains("CustomName");
    }

    @Override
    public void setName(String name) {
        if (name == null || name.isEmpty()) {
            this.namedTag.remove("CustomName");
            return;
        }
        this.namedTag.putString("CustomName", name);
    }

    public boolean isPaired() {
        return this.namedTag.contains("pairx") && this.namedTag.contains("pairz");
    }

    public BlockEntityChest getPair() {
        BlockEntity blockEntity;
        if (this.isPaired() && (blockEntity = this.getLevel().getBlockEntityIfLoaded(this.chunk, new Vector3(this.namedTag.getInt("pairx"), this.y, this.namedTag.getInt("pairz")))) instanceof BlockEntityChest) {
            return (BlockEntityChest)blockEntity;
        }
        return null;
    }

    public boolean pairWith(BlockEntityChest chest) {
        if (this.isPaired() || chest.isPaired() || this.getBlock().getId() != chest.getBlock().getId()) {
            return false;
        }
        this.createPair(chest);
        chest.spawnToAll();
        this.spawnToAll();
        this.checkPairing();
        return true;
    }

    public void createPair(BlockEntityChest chest) {
        this.namedTag.putInt("pairx", (int)chest.x);
        this.namedTag.putInt("pairz", (int)chest.z);
        chest.namedTag.putInt("pairx", (int)this.x);
        chest.namedTag.putInt("pairz", (int)this.z);
    }

    public boolean unpair() {
        if (!this.isPaired()) {
            return false;
        }
        BlockEntityChest chest = this.getPair();
        this.doubleInventory = null;
        this.namedTag.remove("pairx");
        this.namedTag.remove("pairz");
        this.spawnToAll();
        if (chest != null) {
            chest.namedTag.remove("pairx");
            chest.namedTag.remove("pairz");
            chest.doubleInventory = null;
            chest.checkPairing();
            chest.spawnToAll();
        }
        this.checkPairing();
        return true;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag c = this.isPaired() ? new CompoundTag().putString("id", "Chest").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putInt("pairx", this.namedTag.getInt("pairx")).putInt("pairz", this.namedTag.getInt("pairz")) : new CompoundTag().putString("id", "Chest").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z);
        if (this.hasName()) {
            c.put("CustomName", this.namedTag.get("CustomName"));
        }
        return c;
    }
}

