/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntityFurnace;
import cn.nukkit.event.inventory.FurnaceSmeltEvent;
import cn.nukkit.inventory.FurnaceRecipe;
import cn.nukkit.item.Item;
import cn.nukkit.item.ItemArmor;
import cn.nukkit.item.ItemBlock;
import cn.nukkit.item.ItemTool;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.concurrent.ThreadLocalRandom;

public class BlockEntityBlastFurnace
extends BlockEntityFurnace {
    private static final IntSet CAN_SMELT_EXCLUDING_TOOLS_AND_ARMOR = new IntOpenHashSet(new int[]{15, 14, 56, 21, 73, 16, 129, 153, -288, -271, 522, 520, 521, -406, -401, -402, -400, -407, -408, -403, -405});

    public BlockEntityBlastFurnace(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    public String getName() {
        return this.hasName() ? this.namedTag.getString("CustomName") : "Blast Furnace";
    }

    @Override
    public boolean isBlockEntityValid() {
        int blockID = this.level.getBlockIdAt(this.chunk, (int)this.x, (int)this.y, (int)this.z);
        return blockID == 451 || blockID == 469;
    }

    @Override
    public boolean onUpdate() {
        Item fuel;
        boolean canSmelt;
        if (this.closed) {
            return false;
        }
        Item raw = this.inventory.getSmelting();
        if (!(CAN_SMELT_EXCLUDING_TOOLS_AND_ARMOR.contains(raw.getId()) || raw instanceof ItemTool && (raw.getTier() == 4 || raw.getTier() == 2) || raw instanceof ItemArmor && raw.getTier() >= 2 && raw.getTier() <= 4)) {
            if (this.burnTime > 0) {
                --this.burnTime;
                this.burnDuration = (int)Math.ceil((float)this.burnTime / (float)this.maxTime * 100.0f);
                if (this.burnTime == 0) {
                    Block block = this.level.getBlock(this.chunk, (int)this.x, (int)this.y, (int)this.z, true);
                    if (block.getId() == 469) {
                        this.level.setBlock(this, Block.get(451, block.getDamage()), true);
                    }
                    return false;
                }
            }
            this.cookTime = 0;
            this.sendPacket();
            return true;
        }
        boolean ret = false;
        Item product = this.inventory.getResult();
        FurnaceRecipe smelt = this.server.getCraftingManager().matchFurnaceRecipe(raw);
        boolean bl = canSmelt = smelt != null && raw.getCount() > 0 && (smelt.getResult().equals(product) && product.getCount() < product.getMaxStackSize() || product.getId() == 0);
        if (this.burnTime <= 0 && canSmelt && (fuel = this.inventory.getItemFast(1)).getFuelTime() != null && fuel.getCount() > 0) {
            this.checkFuel(fuel.clone());
        }
        if (this.burnTime > 0) {
            --this.burnTime;
            this.burnDuration = (int)Math.ceil((float)this.burnTime / (float)this.maxTime * 100.0f);
            if (this.crackledTime-- <= 0) {
                this.crackledTime = ThreadLocalRandom.current().nextInt(30, 110);
                this.getLevel().addLevelSoundEvent(this.add(0.5, 0.5, 0.5), 283);
            }
            if (smelt != null && canSmelt) {
                ++this.cookTime;
                if (this.cookTime >= 100) {
                    product = Item.get(smelt.getResult().getId(), (Integer)smelt.getResult().getDamage(), product.isNull() ? 1 : product.getCount() + 1);
                    FurnaceSmeltEvent ev = new FurnaceSmeltEvent(this, raw, product);
                    this.server.getPluginManager().callEvent(ev);
                    if (!ev.isCancelled()) {
                        this.inventory.setResult(ev.getResult());
                        this.experience += FURNACE_XP.getOrDefault(ev.getResult().getId(), 0.0).doubleValue();
                        raw.setCount(raw.getCount() - 1);
                        if (raw.getCount() == 0) {
                            raw = new ItemBlock(Block.get(0), 0, 0);
                        }
                        this.inventory.setSmelting(raw);
                    }
                    this.cookTime -= 100;
                }
            } else if (this.burnTime <= 0) {
                this.burnTime = 0;
                this.cookTime = 0;
                this.burnDuration = 0;
            } else {
                this.cookTime = 0;
            }
            ret = true;
        } else {
            Block block = this.level.getBlock(this.chunk, (int)this.x, (int)this.y, (int)this.z, true);
            if (block.getId() == 469) {
                this.level.setBlock(this, Block.get(451, block.getDamage()), true);
            }
            this.burnTime = 0;
            this.cookTime = 0;
            this.burnDuration = 0;
            this.crackledTime = 0;
        }
        this.sendPacket();
        return ret;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        CompoundTag c = new CompoundTag().putString("id", "BlastFurnace").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putShort("BurnDuration", this.burnDuration).putShort("BurnTime", this.burnTime).putShort("CookTime", this.cookTime);
        if (this.hasName()) {
            c.put("CustomName", this.namedTag.get("CustomName"));
        }
        return c;
    }
}

