/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.blockentity;

import cn.nukkit.Player;
import cn.nukkit.Server;
import cn.nukkit.block.Block;
import cn.nukkit.blockentity.BlockEntitySpawnable;
import cn.nukkit.event.entity.EntityPotionEffectEvent;
import cn.nukkit.inventory.BeaconInventory;
import cn.nukkit.inventory.Inventory;
import cn.nukkit.item.Item;
import cn.nukkit.level.format.FullChunk;
import cn.nukkit.nbt.tag.CompoundTag;
import cn.nukkit.potion.Effect;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;

public class BlockEntityBeacon
extends BlockEntitySpawnable {
    private long currentTick;
    private static final int POWER_LEVEL_MAX = 4;
    private static final IntSet ALLOWED_EFFECTS = new IntOpenHashSet(new int[]{0, 1, 3, 11, 8, 5, 10});

    public BlockEntityBeacon(FullChunk chunk, CompoundTag nbt) {
        super(chunk, nbt);
    }

    @Override
    protected void initBlockEntity() {
        if (!this.namedTag.contains("Lock")) {
            this.namedTag.putString("Lock", "");
        }
        if (!this.namedTag.contains("Levels")) {
            this.namedTag.putInt("Levels", 0);
        }
        if (!this.namedTag.contains("Primary")) {
            this.namedTag.putInt("Primary", 0);
        }
        if (!this.namedTag.contains("Secondary")) {
            this.namedTag.putInt("Secondary", 0);
        }
        this.scheduleUpdate();
        super.initBlockEntity();
    }

    @Override
    public boolean isBlockEntityValid() {
        return this.level.getBlockIdAt(this.chunk, (int)this.x, (int)this.y, (int)this.z) == 138;
    }

    @Override
    public CompoundTag getSpawnCompound() {
        return new CompoundTag().putString("id", "Beacon").putInt("x", (int)this.x).putInt("y", (int)this.y).putInt("z", (int)this.z).putString("Lock", this.namedTag.getString("Lock")).putInt("Levels", this.namedTag.getInt("Levels")).putInt("Primary", this.namedTag.getInt("Primary")).putInt("Secondary", this.namedTag.getInt("Secondary"));
    }

    @Override
    public boolean onUpdate() {
        if (this.closed) {
            return false;
        }
        if (this.currentTick++ % 80L != 0L) {
            return true;
        }
        int power = this.calculatePowerLevel();
        if (power == -1) {
            return true;
        }
        int oldPowerLevel = this.getPowerLevel();
        this.setPowerLevel(power);
        if (this.getPowerLevel() < 1 || !this.hasSkyAccess()) {
            if (oldPowerLevel > 0) {
                this.getLevel().addLevelSoundEvent(this, 231);
            }
            return true;
        }
        if (oldPowerLevel < 1) {
            this.getLevel().addLevelSoundEvent(this, 229);
        } else {
            this.getLevel().addLevelSoundEvent(this, 230);
        }
        int powerLevel = this.getPowerLevel();
        int duration = (9 + (powerLevel << 1)) * 20;
        for (Map.Entry<Long, Player> entry : this.level.getPlayers().entrySet()) {
            Effect e;
            Player p = entry.getValue();
            if (!(p.distance(this) < (double)(10 + powerLevel * 10))) continue;
            if (this.getPrimaryPower() != 0) {
                e = Effect.getEffect(this.getPrimaryPower());
                e.setDuration(duration);
                if (this.getSecondaryPower() == this.getPrimaryPower()) {
                    e.setAmplifier(1);
                } else {
                    e.setAmplifier(0);
                }
                e.setVisible(false);
                p.addEffect(e, EntityPotionEffectEvent.Cause.BEACON);
            }
            if (this.getSecondaryPower() == 10) {
                e = Effect.getEffect(10);
                e.setDuration(duration);
                e.setAmplifier(0);
                e.setVisible(false);
                p.addEffect(e, EntityPotionEffectEvent.Cause.BEACON);
            }
            if (powerLevel < 4) continue;
            p.awardAchievement("fullBeacon");
        }
        return true;
    }

    private boolean hasSkyAccess() {
        int tileX = this.getFloorX();
        int tileY = this.getFloorY();
        int tileZ = this.getFloorZ();
        for (int y = tileY + 1; y <= this.level.getMaxBlockY(); ++y) {
            int testBlockId = this.level.getBlockIdAt(this.chunk, tileX, y, tileZ);
            if (Block.isBlockTransparentById(testBlockId)) continue;
            return false;
        }
        return true;
    }

    private int calculatePowerLevel() {
        int tileX = this.getFloorX();
        int tileY = this.getFloorY();
        int tileZ = this.getFloorZ();
        for (int powerLevel = 1; powerLevel <= 4; ++powerLevel) {
            int queryY = tileY - powerLevel;
            for (int queryX = tileX - powerLevel; queryX <= tileX + powerLevel; ++queryX) {
                for (int queryZ = tileZ - powerLevel; queryZ <= tileZ + powerLevel; ++queryZ) {
                    int testBlockId = this.getBlockIdIfLoaded(queryX, queryY, queryZ);
                    if (testBlockId == -1) {
                        return -1;
                    }
                    if (testBlockId == 42 || testBlockId == 41 || testBlockId == 133 || testBlockId == 57 || testBlockId == 525) continue;
                    return powerLevel - 1;
                }
            }
        }
        return 4;
    }

    private int getBlockIdIfLoaded(int bx, int by, int bz) {
        if (by < this.level.getMinBlockY() || by > this.level.getMaxBlockY()) {
            return 0;
        }
        int cx = bx >> 4;
        int cz = bz >> 4;
        FullChunk fullChunk = this.chunk;
        if ((fullChunk == null || cx != fullChunk.getX() || cz != fullChunk.getZ()) && (fullChunk = this.level.getChunkIfLoaded(cx, cz)) == null) {
            return -1;
        }
        return fullChunk.getBlockId(bx & 0xF, by, bz & 0xF);
    }

    @Override
    public void setDirty() {
        super.setDirty();
        this.spawnToAll();
    }

    public int getPowerLevel() {
        return this.namedTag.getInt("Level");
    }

    public void setPowerLevel(int level) {
        int currentLevel = this.getPowerLevel();
        if (level != currentLevel) {
            this.namedTag.putInt("Level", level);
            this.setDirty();
        }
    }

    public int getPrimaryPower() {
        return this.namedTag.getInt("Primary");
    }

    public void setPrimaryPower(int power) {
        int currentPower = this.getPrimaryPower();
        if (power != currentPower) {
            this.namedTag.putInt("Primary", power);
            this.setDirty();
        }
    }

    public int getSecondaryPower() {
        return this.namedTag.getInt("Secondary");
    }

    public void setSecondaryPower(int power) {
        int currentPower = this.getSecondaryPower();
        if (power != currentPower) {
            this.namedTag.putInt("Secondary", power);
            this.setDirty();
        }
    }

    @Override
    public boolean updateCompoundTag(CompoundTag nbt, Player player) {
        if (!nbt.getString("id").equals("Beacon")) {
            return false;
        }
        Inventory inv = player.getWindowById(4);
        if (inv != null) {
            if (!BeaconInventory.ITEMS.contains(inv.getItemFast(0).getId())) {
                Server.getInstance().getLogger().debug(player.getName() + " tried to set effect but there's no payment in beacon inventory");
                return false;
            }
        } else {
            Server.getInstance().getLogger().debug(player.getName() + " tried to set effect but beacon inventory is null");
            return false;
        }
        inv.setItem(0, Item.get(0));
        int primary = nbt.getInt("primary");
        if (ALLOWED_EFFECTS.contains(primary)) {
            this.setPrimaryPower(primary);
        } else {
            Server.getInstance().getLogger().debug(player.getName() + " tried to set an invalid primary effect to a beacon: " + primary);
        }
        int secondary = nbt.getInt("secondary");
        if (ALLOWED_EFFECTS.contains(secondary)) {
            this.setSecondaryPower(secondary);
        } else {
            Server.getInstance().getLogger().debug(player.getName() + " tried to set an invalid secondary effect to a beacon: " + secondary);
        }
        this.getLevel().addLevelSoundEvent(this, 232);
        return true;
    }
}

