/*
 * Decompiled with CFR 0.152.
 */
package cn.nukkit.block.custom.properties;

import cn.nukkit.block.custom.properties.BlockProperty;
import cn.nukkit.block.custom.properties.BlockPropertyUtils;
import cn.nukkit.block.custom.properties.exception.InvalidBlockPropertyMetaException;
import cn.nukkit.block.custom.properties.exception.InvalidBlockPropertyPersistenceValueException;
import cn.nukkit.block.custom.properties.exception.InvalidBlockPropertyValueException;
import cn.nukkit.math.NukkitMath;
import com.google.common.base.Preconditions;
import java.io.Serializable;

public class IntBlockProperty
extends BlockProperty<Integer> {
    private static final long serialVersionUID = -2239010977496415152L;
    private final int minValue;
    private final int maxValue;

    public IntBlockProperty(String name, boolean exportedToItem, int maxValue, int minValue, int bitSize) {
        this(name, exportedToItem, maxValue, minValue, bitSize, name);
    }

    public IntBlockProperty(String name, boolean exportedToItem, int maxValue, int minValue) {
        this(name, exportedToItem, maxValue, minValue, BlockPropertyUtils.bitLength(maxValue - minValue));
    }

    public IntBlockProperty(String name, boolean exportedToItem, int maxValue) {
        this(name, exportedToItem, maxValue, 0);
    }

    public IntBlockProperty(String name, boolean exportedToItem, int maxValue, int minValue, int bitSize, String persistenceName) {
        super(name, exportedToItem, persistenceName, bitSize);
        int delta = maxValue - minValue;
        Preconditions.checkArgument(delta > 0, "maxValue must be higher than minValue. Got min:%s and max:%s", minValue, maxValue);
        int mask = -1 >>> 32 - bitSize;
        Preconditions.checkArgument(delta <= mask, "The data range from %s to %s can't be stored in %s bits", (Object)minValue, (Object)maxValue, (Object)bitSize);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public int getMetaForValue(Integer value) {
        if (value == null) {
            return 0;
        }
        return this.getMetaForValue((int)value);
    }

    @Override
    public int getMetaForValue(int value) {
        try {
            this.validateDirectly(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBlockPropertyValueException(this, null, (Serializable)Integer.valueOf(value), e);
        }
        return value - this.minValue;
    }

    @Override
    public Integer getValueForMeta(int meta) {
        return this.getIntValueForMeta(meta);
    }

    @Override
    public int getIntValueForMeta(int meta) {
        try {
            this.validateMetaDirectly(meta);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidBlockPropertyMetaException(this, (Number)meta, (Number)meta, e);
        }
        return this.minValue + meta;
    }

    @Override
    protected void validateDirectly(Integer value) {
        if (value == null) {
            return;
        }
        this.validateDirectly((int)value);
    }

    @Override
    private void validateDirectly(int newValue) {
        Preconditions.checkArgument(newValue >= this.minValue, "New value (%s) must be higher or equals to %s", newValue, this.minValue);
        Preconditions.checkArgument(this.maxValue >= newValue, "New value (%s) must be less or equals to %s", newValue, this.maxValue);
    }

    @Override
    protected void validateMetaDirectly(int meta) {
        int max = this.maxValue - this.minValue;
        Preconditions.checkArgument(0 <= meta && meta <= max, "The meta %s is outside the range of 0 .. ", meta, max);
    }

    @Override
    public Serializable getPersistenceValueForMeta(int meta) {
        return Integer.valueOf(this.getIntValueForMeta(meta));
    }

    @Override
    public int getMetaForPersistenceValue(String persistenceValue) {
        try {
            return this.getMetaForValue(Integer.parseInt(persistenceValue));
        }
        catch (InvalidBlockPropertyValueException | NumberFormatException e) {
            throw new InvalidBlockPropertyPersistenceValueException(this, null, persistenceValue, e);
        }
    }

    public int clamp(int value) {
        return NukkitMath.clamp(value, this.getMinValue(), this.getMaxValue());
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public int getMinValue() {
        return this.minValue;
    }

    @Override
    public Integer getDefaultValue() {
        return this.minValue;
    }

    @Override
    public boolean isDefaultIntValue(int value) {
        return this.minValue == value;
    }

    @Override
    public int getDefaultIntValue() {
        return this.minValue;
    }

    @Override
    public boolean isDefaultValue(Integer value) {
        return value == null || this.minValue == value;
    }

    @Override
    public Class<Integer> getValueClass() {
        return Integer.class;
    }

    public IntBlockProperty exportingToItems(boolean exportedToItem) {
        return new IntBlockProperty(this.getName(), exportedToItem, this.getMaxValue(), this.getMinValue(), this.getBitSize(), this.getPersistenceName());
    }

    public IntBlockProperty copy() {
        return new IntBlockProperty(this.getName(), this.isExportedToItem(), this.getMaxValue(), this.getMinValue(), this.getBitSize(), this.getPersistenceName());
    }
}

